/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.argos;

import com.argosnotary.argos.argos4j.FileCollector;
import com.argosnotary.argos.argos4j.RemoteFileCollector;
import com.argosnotary.argos.argos4j.RemoteZipFileCollector;
import com.xebialabs.deployit.community.argos.ArgosConfiguration;
import com.xebialabs.deployit.community.argos.ArgosError;
import com.xebialabs.deployit.community.argos.model.XldClientConfig;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.credentials.Credentials;
import com.xebialabs.deployit.plugin.credentials.UsernamePasswordCredentials;
import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.auth.BasicAuthRequestInterceptor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarCollectorsFactory {
    private static final Logger log = LoggerFactory.getLogger(DarCollectorsFactory.class);

    private DarCollectorsFactory() {
    }

    public static List<FileCollector> getCollectors(XldClientConfig xldConf, Version version) {
        ArrayList<FileCollector> collectors = new ArrayList<FileCollector>();
        collectors.add((FileCollector)DarCollectorsFactory.getDarCollector(xldConf, version.getId()));
        collectors.addAll(DarCollectorsFactory.getRemoteFileCollectors(version));
        return collectors;
    }

    public static List<FileCollector> getCollectors(XldClientConfig xldConf, String versionId, List<Map<String, String>> remoteDeployables) {
        ArrayList<FileCollector> collectors = new ArrayList<FileCollector>();
        collectors.add((FileCollector)DarCollectorsFactory.getDarCollector(xldConf, versionId));
        remoteDeployables.forEach(deployable -> collectors.add(DarCollectorsFactory.getRemoteFileCollector((String)deployable.get("uri"), (String)deployable.get("username"), (String)deployable.get("password"))));
        return collectors;
    }

    private static RemoteZipFileCollector getDarCollector(XldClientConfig xldConf, String versionId) {
        String downloadKey = DarCollectorsFactory.getVersionDownloadKey(xldConf, versionId);
        return RemoteZipFileCollector.builder().url(ArgosConfiguration.getXldUrlForExport(downloadKey)).username(xldConf.getUsername()).password(xldConf.getPassword().toCharArray()).build();
    }

    private static List<FileCollector> getRemoteFileCollectors(Version version) {
        ArrayList<FileCollector> fileCollectors = new ArrayList<FileCollector>();
        version.getDeployables().forEach(deployable -> {
            String uri;
            if (deployable instanceof SourceArtifact && !(uri = ((SourceArtifact)deployable).getFileUri()).startsWith("internal:")) {
                RemoteFileCollector.RemoteFileCollectorBuilder fileCollectorBuilder = null;
                try {
                    fileCollectorBuilder = RemoteFileCollector.builder().url(new URL(uri));
                }
                catch (MalformedURLException e) {
                    throw new ArgosError(String.format("Exception during Argos Notary verify: [%s]", e.getMessage()));
                }
                Optional<Credentials> credentials = Optional.ofNullable(((SourceArtifact)deployable).getCredentials());
                if (credentials.isPresent()) {
                    fileCollectorBuilder.username(((UsernamePasswordCredentials)credentials.get()).getUsername()).password(((UsernamePasswordCredentials)credentials.get()).getPassword().toCharArray());
                }
                fileCollectors.add((FileCollector)fileCollectorBuilder.build());
            }
        });
        return fileCollectors;
    }

    private static FileCollector getRemoteFileCollector(String uri, String username, String password) {
        log.info("Create remote file collector" + uri + " " + username + " " + password);
        RemoteFileCollector.RemoteFileCollectorBuilder fileCollectorBuilder = null;
        try {
            fileCollectorBuilder = RemoteFileCollector.builder().url(new URL(uri));
        }
        catch (MalformedURLException e) {
            throw new ArgosError(String.format("Exception during Argos Notary verify: [%s]", e.getMessage()));
        }
        if (username != null && password != null) {
            fileCollectorBuilder.username(username).password(password.toCharArray());
        }
        return fileCollectorBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersionDownloadKey(XldClientConfig xldConf, String versionId) {
        String keyUrl = ArgosConfiguration.getXldUrlForDownloadKey(versionId);
        RequestTemplate requestTemplate = new RequestTemplate();
        requestTemplate.method(Request.HttpMethod.GET);
        requestTemplate.target(keyUrl);
        new BasicAuthRequestInterceptor(xldConf.getUsername(), xldConf.getPassword()).apply(requestTemplate);
        Client.Default client = new Client.Default(null, null);
        Request request = requestTemplate.resolve(new HashMap()).request();
        try (Response response = client.execute(request, new Request.Options());){
            if (response.status() == 200) {
                String string = response.body().toString();
                return string;
            }
            throw new ArgosError("status code : " + response.status() + " returned");
        }
        catch (IOException e) {
            throw new ArgosError(e.getMessage(), e);
        }
    }
}

