/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.argos;

import com.argosnotary.argos.argos4j.Argos4j;
import com.argosnotary.argos.argos4j.Argos4jSettings;
import com.argosnotary.argos.domain.SupplyChainHelper;
import com.xebialabs.deployit.community.argos.ArgosConfiguration;
import com.xebialabs.deployit.community.argos.ArgosError;
import com.xebialabs.deployit.community.argos.model.ServiceAccount;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.Version;
import java.util.Arrays;
import java.util.List;

public class ArgosXldClientSettings {
    private final Argos4j argos4j;
    private final char[] passphrase;

    public ArgosXldClientSettings(ExecutionContext context, Version version) {
        String supplyChain = (String)version.getApplication().getProperty("argosSupplyChain");
        ServiceAccount saAccount = (ServiceAccount)((Object)version.getApplication().getProperty("argosServiceAccount"));
        if (saAccount == null) {
            context.logError(String.format("Argos SA not set on Application [%s]", version.getApplication().getName()));
            throw new ArgosError("Argos SA not set on Application");
        }
        if (supplyChain == null) {
            context.logError(String.format("Argos Supply Chain not set on Application [%s]", version.getApplication().getName()));
            throw new ArgosError("Argos Supply Chain not set on Application");
        }
        this.passphrase = saAccount.getPassphrase().toCharArray();
        List path = SupplyChainHelper.getSupplyChainPath((String)supplyChain);
        String supplyChainName = SupplyChainHelper.getSupplyChainName((String)supplyChain);
        Argos4jSettings settings = Argos4jSettings.builder().path(path).supplyChainName(supplyChainName).keyId(saAccount.getKeyId()).argosServerBaseUrl(ArgosConfiguration.getArgosServerBaseUrl()).build();
        this.argos4j = new Argos4j(settings);
    }

    public static ArgosXldClientSettingsBuilder builder() {
        return new ArgosXldClientSettingsBuilder();
    }

    public Argos4j getArgos4j() {
        return this.argos4j;
    }

    public char[] getPassphrase() {
        return this.passphrase;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgosXldClientSettings)) {
            return false;
        }
        ArgosXldClientSettings other = (ArgosXldClientSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Argos4j this$argos4j = this.getArgos4j();
        Argos4j other$argos4j = other.getArgos4j();
        if (this$argos4j == null ? other$argos4j != null : !this$argos4j.equals(other$argos4j)) {
            return false;
        }
        return Arrays.equals(this.getPassphrase(), other.getPassphrase());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArgosXldClientSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Argos4j $argos4j = this.getArgos4j();
        result = result * 59 + ($argos4j == null ? 43 : $argos4j.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassphrase());
        return result;
    }

    public ArgosXldClientSettings(Argos4j argos4j, char[] passphrase) {
        this.argos4j = argos4j;
        this.passphrase = passphrase;
    }

    public static class ArgosXldClientSettingsBuilder {
        private ExecutionContext context;
        private Version version;

        ArgosXldClientSettingsBuilder() {
        }

        public ArgosXldClientSettingsBuilder context(ExecutionContext context) {
            this.context = context;
            return this;
        }

        public ArgosXldClientSettingsBuilder version(Version version) {
            this.version = version;
            return this;
        }

        public ArgosXldClientSettings build() {
            return new ArgosXldClientSettings(this.context, this.version);
        }

        public String toString() {
            return "ArgosXldClientSettings.ArgosXldClientSettingsBuilder(context=" + this.context + ", version=" + this.version + ")";
        }
    }
}

