/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.argos;

import com.argosnotary.argos.argos4j.Argos4jError;
import com.argosnotary.argos.argos4j.VerificationResult;
import com.argosnotary.argos.argos4j.VerifyBuilder;
import com.xebialabs.deployit.community.argos.ArgosConfiguration;
import com.xebialabs.deployit.community.argos.ArgosXldClientSettings;
import com.xebialabs.deployit.community.argos.DarCollectorsFactory;
import com.xebialabs.deployit.community.argos.model.XldClientConfig;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.Version;
import java.util.List;

public class ArgosVerifier {
    private ArgosVerifier() {
    }

    public static boolean versionIsValid(ExecutionContext context, Version version) {
        ArgosXldClientSettings settings = ArgosXldClientSettings.builder().context(context).version(version).build();
        List path = settings.getArgos4j().getSettings().getPath();
        VerifyBuilder verifyBuilder = path != null && !path.isEmpty() ? settings.getArgos4j().getVerifyBuilder(path) : settings.getArgos4j().getVerifyBuilder();
        XldClientConfig xldConf = ArgosConfiguration.getXldClientConfig(context.getRepository());
        DarCollectorsFactory.getCollectors(xldConf, version).forEach(arg_0 -> ((VerifyBuilder)verifyBuilder).addFileCollector(arg_0));
        VerificationResult verifyResult = null;
        try {
            verifyResult = verifyBuilder.verify();
        }
        catch (Argos4jError exc) {
            context.logError(String.format("Exception during Argos Notary verify: [%s]", exc.getMessage()));
            return false;
        }
        if (verifyResult != null && verifyResult.isRunIsValid()) {
            context.logOutput(String.format("Application [%s] version [%s] is valid according to Argos Notary", version.getApplication().getName(), version.getName()));
            return true;
        }
        context.logError(String.format("Application [%s] version [%s] is invalid according to Argos Notary", version.getApplication().getName(), version.getName()));
        return false;
    }
}

