/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.argos;

import com.xebialabs.deployit.community.argos.ArgosConfiguration;
import com.xebialabs.deployit.community.argos.ArgosVerificationStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgosVerificationStepGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ArgosVerificationStepGenerator.class);

    private ArgosVerificationStepGenerator() {
    }

    @Contributor
    public static void contribute(Deltas deltas, DeploymentPlanningContext context) {
        Environment environment = context.getDeployedApplication().getEnvironment();
        boolean noVerifyOperations = deltas.getDeltas().stream().map(Delta::getOperation).allMatch(ArgosConfiguration.OPERATIONS_WITHOUT_VERIFICATION::contains);
        if (noVerifyOperations) {
            logger.info("no verification");
        } else if (ArgosConfiguration.isEnabled(environment)) {
            context.addStep((Step)new ArgosVerificationStep(context.getDeployedApplication().getVersion(), ArgosConfiguration.getActionOnInvalid(environment)));
        }
    }
}

