/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.argos;

import com.xebialabs.deployit.community.argos.ArgosConfiguration;
import com.xebialabs.deployit.community.argos.ArgosVerifier;
import com.xebialabs.deployit.community.argos.model.ActionOnInvalid;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Version;

public class ArgosVerificationStep
implements Step {
    private Version version;
    private ActionOnInvalid action;

    public ArgosVerificationStep(Version version, ActionOnInvalid action) {
        this.version = version;
        this.action = action;
    }

    public StepExitCode execute(ExecutionContext context) throws Exception {
        if (ArgosVerifier.versionIsValid(context, this.version)) {
            context.logOutput(String.format(ArgosConfiguration.getArgosValidTemplate(), this.version.getName()));
            return StepExitCode.SUCCESS;
        }
        return this.handleFail(context);
    }

    private StepExitCode handleFail(ExecutionContext context) {
        switch (this.action) {
            case ABORT: {
                context.logError(String.format(ArgosConfiguration.getArgosActionTemplate(ActionOnInvalid.ABORT), this.version.getName()));
                return StepExitCode.FAIL;
            }
            case WARN: {
                context.logError(String.format(ArgosConfiguration.getArgosActionTemplate(ActionOnInvalid.WARN), this.version.getName()));
                return StepExitCode.SUCCESS;
            }
            case NONE: {
                context.logError(String.format(ArgosConfiguration.getArgosActionTemplate(ActionOnInvalid.NONE), this.version.getName()));
                return StepExitCode.SUCCESS;
            }
        }
        context.logError(String.format("Unknown action: %s", new Object[]{this.action}));
        return StepExitCode.FAIL;
    }

    public String getDescription() {
        return "Argos Notary Verification Step";
    }

    public int getOrder() {
        return 0;
    }

    public boolean skippable() {
        return false;
    }
}

