/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.argos;

import com.argosnotary.argos.argos4j.Argos4jError;
import com.xebialabs.deployit.community.argos.ArgosCollectLink;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.Version;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ArgosCollectLinkTask {
    private static final String LAYOUT_SEGMENT_NAME_ARGUMENT = "layoutSegmentName";
    private static final String STEP_NAME_ARGUMENT = "stepName";

    private ArgosCollectLinkTask() {
    }

    @Delegate(name="collectArgosLink")
    public static List<Step> collectArgosLink(final ConfigurationItem ci, String method, Map<String, String> arguments, final Parameters parameters) {
        Step step = new Step(){

            public int getOrder() {
                return 1;
            }

            public String getDescription() {
                return "Collect Argos Link Object";
            }

            public StepExitCode execute(ExecutionContext ctx) throws NoSuchAlgorithmException, IOException {
                Version version = (Version)ci;
                ctx.logOutput(String.format("Collect artifacts for Application [%s] with version [%s]", version.getApplication().getName(), version.getName()));
                try {
                    ArgosCollectLink.collectLink(ctx, version, (String)parameters.getProperty(ArgosCollectLinkTask.LAYOUT_SEGMENT_NAME_ARGUMENT), (String)parameters.getProperty(ArgosCollectLinkTask.STEP_NAME_ARGUMENT));
                    ctx.logOutput(String.format("Link object stored in Argos Notary for Application [%s] version [%s]", version.getApplication().getName(), version.getName()));
                    ctx.logOutput(String.format("for segment: [%s] and step: [%s]", parameters.getProperty(ArgosCollectLinkTask.LAYOUT_SEGMENT_NAME_ARGUMENT), parameters.getProperty(ArgosCollectLinkTask.STEP_NAME_ARGUMENT)));
                    return StepExitCode.SUCCESS;
                }
                catch (Argos4jError exc) {
                    ctx.logError(String.format("Exception during Argos Notary add Link: [%s]", exc.getMessage()));
                    return StepExitCode.FAIL;
                }
            }
        };
        ArrayList<Step> stepList = new ArrayList<Step>();
        stepList.add(step);
        return stepList;
    }
}

