/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler;

import com.arellomobile.mvp.DefaultView;
import com.arellomobile.mvp.DefaultViewState;
import com.arellomobile.mvp.InjectViewState;
import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.compiler.ClassGeneratingParams;
import com.arellomobile.mvp.compiler.ClassGenerator;
import com.arellomobile.mvp.compiler.MvpCompiler;
import com.arellomobile.mvp.compiler.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class ViewStateProviderClassGenerator
extends ClassGenerator<TypeElement> {
    public static final String MVP_PRESENTER_CLASS = MvpPresenter.class.getCanonicalName();
    private Set<TypeElement> mUsedViews = new HashSet<TypeElement>();
    private List<String> mPresenterClassNames = new ArrayList<String>();

    @Override
    public boolean generate(TypeElement typeElement, List<ClassGeneratingParams> classGeneratingParamsList) {
        String fullPresenterClassName = typeElement.toString();
        this.mPresenterClassNames.add(fullPresenterClassName);
        String presenterClassName = fullPresenterClassName.substring(fullPresenterClassName.lastIndexOf(".") + 1);
        String viewState = this.getViewStateClassFromAnnotationParams(typeElement);
        if (viewState == null) {
            String view = this.getViewClassFromAnnotationParams(typeElement);
            if (view == null) {
                view = this.getViewClassFromGeneric(typeElement);
            }
            if (view != null) {
                TypeElement viewTypeElement;
                if (view.contains("<")) {
                    view = view.substring(0, view.indexOf("<"));
                }
                if ((viewTypeElement = MvpCompiler.getElementUtils().getTypeElement(view)) == null) {
                    throw new IllegalArgumentException("View \"" + view + "\" for " + typeElement + " cannot be found");
                }
                this.mUsedViews.add(viewTypeElement);
                viewState = Util.getFullClassName(viewTypeElement) + "$$State";
            }
        }
        String builder = "package " + fullPresenterClassName.substring(0, fullPresenterClassName.lastIndexOf(".")) + ";\n" + "\n" + "import com.arellomobile.mvp.ViewStateProvider;\n" + "import com.arellomobile.mvp.MvpView;\n" + "import com.arellomobile.mvp.viewstate.MvpViewState;\n" + "\npublic class " + presenterClassName + "$$ViewStateProvider" + " extends ViewStateProvider {\n" + "\t\n" + "\t@Override\n" + "\tpublic MvpViewState<? extends MvpView> getViewState() {\n";
        builder = viewState == null ? builder + "\t\tthrow new RuntimeException(" + fullPresenterClassName + " should has view\");\n" : builder + "\t\treturn new " + viewState + "();\n";
        builder = builder + "\t}\n}";
        ClassGeneratingParams classGeneratingParams = new ClassGeneratingParams();
        classGeneratingParams.setName(fullPresenterClassName + "$$ViewStateProvider");
        classGeneratingParams.setBody(builder);
        classGeneratingParamsList.add(classGeneratingParams);
        return true;
    }

    private String getViewClassFromAnnotationParams(TypeElement typeElement) {
        InjectViewState annotation = typeElement.getAnnotation(InjectViewState.class);
        String mvpViewClassName = "";
        if (annotation != null) {
            TypeMirror value = null;
            try {
                annotation.view();
            }
            catch (MirroredTypeException mte) {
                value = mte.getTypeMirror();
            }
            mvpViewClassName = Util.getFullClassName(value);
        }
        if (mvpViewClassName.isEmpty() || DefaultView.class.getName().equals(mvpViewClassName)) {
            return null;
        }
        return mvpViewClassName;
    }

    private String getViewStateClassFromAnnotationParams(TypeElement typeElement) {
        InjectViewState annotation = typeElement.getAnnotation(InjectViewState.class);
        String mvpViewStateClassName = "";
        if (annotation != null) {
            try {
                annotation.value();
            }
            catch (MirroredTypeException mte) {
                TypeMirror value = mte.getTypeMirror();
                mvpViewStateClassName = value.toString();
            }
        }
        if (mvpViewStateClassName.isEmpty() || DefaultViewState.class.getName().equals(mvpViewStateClassName)) {
            return null;
        }
        return mvpViewStateClassName;
    }

    private String getViewClassFromGeneric(TypeElement typeElement) {
        TypeMirror superclass = typeElement.asType();
        Map<String, String> parentTypes = Collections.emptyMap();
        if (!typeElement.getTypeParameters().isEmpty()) {
            MvpCompiler.getMessager().printMessage(Diagnostic.Kind.WARNING, "Your " + typeElement.getSimpleName() + " is typed. @InjectViewState may generate wrong code. Your can set view/view state class manually.");
        }
        while (superclass.getKind() != TypeKind.NONE) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            List<? extends TypeMirror> typeArguments = ((DeclaredType)superclass).getTypeArguments();
            List<? extends TypeParameterElement> typeParameters = superclassElement.getTypeParameters();
            if (typeArguments.size() > typeParameters.size()) {
                throw new IllegalArgumentException("Code generation for interface " + typeElement.getSimpleName() + " failed. Simplify your generics. (" + typeArguments + " vs " + typeParameters + ")");
            }
            HashMap<String, String> types = new HashMap<String, String>();
            for (int i = 0; i < typeArguments.size(); ++i) {
                types.put(typeParameters.get(i).toString(), Util.fillGenerics(parentTypes, typeArguments.get(i)));
            }
            if (superclassElement.toString().equals(MVP_PRESENTER_CLASS)) {
                return Util.fillGenerics(parentTypes, typeArguments);
            }
            parentTypes = types;
            superclass = superclassElement.getSuperclass();
        }
        return "";
    }

    public Set<TypeElement> getUsedViews() {
        return this.mUsedViews;
    }

    public List<String> getPresenterClassNames() {
        return this.mPresenterClassNames;
    }
}

