/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler;

import com.arellomobile.mvp.compiler.ClassGeneratingParams;
import com.arellomobile.mvp.compiler.ClassGenerator;
import com.arellomobile.mvp.compiler.Util;
import com.arellomobile.mvp.presenter.InjectPresenter;
import com.arellomobile.mvp.presenter.PresenterType;
import com.arellomobile.mvp.presenter.ProvidePresenter;
import com.arellomobile.mvp.presenter.ProvidePresenterTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class PresenterBinderClassGenerator
extends ClassGenerator<VariableElement> {
    public static final String PRESENTER_FIELD_ANNOTATION = InjectPresenter.class.getName();
    public static final String PROVIDE_PRESENTER = ProvidePresenter.class.getName();
    public static final String PROVIDE_PRESENTER_TAG = ProvidePresenterTag.class.getName();
    private final Set<TypeElement> mPresentersContainers = new HashSet<TypeElement>();

    @Override
    public boolean generate(VariableElement variableElement, List<ClassGeneratingParams> classGeneratingParamsList) {
        Element enclosingElement = variableElement.getEnclosingElement();
        if (!(enclosingElement instanceof TypeElement)) {
            throw new RuntimeException("Only class fields could be annotated as @InjectPresenter: " + variableElement + " at " + enclosingElement);
        }
        if (this.mPresentersContainers.contains(enclosingElement)) {
            return false;
        }
        TypeElement presentersContainer = (TypeElement)enclosingElement;
        this.mPresentersContainers.add(presentersContainer);
        String fullClassName = Util.getFullClassName(presentersContainer);
        ClassGeneratingParams classGeneratingParams = new ClassGeneratingParams();
        classGeneratingParams.setName(fullClassName + "$$PresentersBinder");
        String parentClassName = presentersContainer.toString();
        String viewClassName = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String builder = "package " + fullClassName.substring(0, fullClassName.lastIndexOf(".")) + ";\n" + "\n" + "import java.util.ArrayList;\n" + "import java.util.List;\n" + "\n" + "import com.arellomobile.mvp.PresenterBinder;\n" + "import com.arellomobile.mvp.presenter.PresenterField;\n" + "import com.arellomobile.mvp.MvpPresenter;\n" + "import com.arellomobile.mvp.presenter.PresenterType;\n" + "\n" + "public class " + viewClassName + "$$PresentersBinder" + " extends PresenterBinder<" + parentClassName + "> {\n";
        List<Field> fields = this.collectFields(presentersContainer);
        List<PresenterProvider> presenterProviders = this.collectPresenterProviders(presentersContainer);
        List<TagProvider> tagProviders = this.collectTagProviders(presentersContainer);
        this.bindProvidersToFields(fields, presenterProviders);
        this.bindTagProvidersToFields(fields, tagProviders);
        for (Field field : fields) {
            builder = PresenterBinderClassGenerator.generatePresenterBinderClass(builder, parentClassName, field);
        }
        builder = PresenterBinderClassGenerator.generateGetPresentersMethod(builder, fields, parentClassName);
        builder = builder + "}\n";
        classGeneratingParams.setBody(builder);
        classGeneratingParamsList.add(classGeneratingParams);
        return true;
    }

    private void bindProvidersToFields(List<Field> fields, List<PresenterProvider> presenterProviders) {
        if (fields.isEmpty() || presenterProviders.isEmpty()) {
            return;
        }
        for (PresenterProvider presenterProvider : presenterProviders) {
            TypeMirror providerTypeMirror = presenterProvider.mClazz.asElement().asType();
            for (Field field : fields) {
                if (!field.mClazz.equals(providerTypeMirror) || field.mType != presenterProvider.mType || field.mTag == null && presenterProvider.mTag != null || field.mTag != null && !field.mTag.equals(presenterProvider.mTag) || field.mPresenterId == null && presenterProvider.mPresenterId != null || field.mPresenterId != null && !field.mPresenterId.equals(presenterProvider.mPresenterId)) continue;
                field.setPresenterProviderMethodName(presenterProvider.mName);
            }
        }
    }

    private void bindTagProvidersToFields(List<Field> fields, List<TagProvider> tagProviders) {
        if (fields.isEmpty() || tagProviders.isEmpty()) {
            return;
        }
        for (TagProvider tagProvider : tagProviders) {
            TypeMirror providerTypeMirror = tagProvider.mPresenterClass.asElement().asType();
            for (Field field : fields) {
                if (!field.mClazz.equals(providerTypeMirror) || field.mType != tagProvider.mType || field.mPresenterId == null && tagProvider.mPresenterId != null || field.mPresenterId != null && !field.mPresenterId.equals(tagProvider.mPresenterId)) continue;
                field.setPresenterTagProviderMethodName(tagProvider.mMethodName);
            }
        }
    }

    private List<Field> collectFields(TypeElement presentersContainer) {
        ArrayList<Field> fields = new ArrayList<Field>();
        block0: for (Element element : presentersContainer.getEnclosedElements()) {
            if (!(element instanceof VariableElement)) continue;
            VariableElement presenterFieldElement = (VariableElement)element;
            for (AnnotationMirror annotationMirror : presenterFieldElement.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().toString().equals(PRESENTER_FIELD_ANNOTATION)) continue;
                String type = null;
                String tag = null;
                String presenterId = null;
                String name = element.toString();
                TypeMirror clazz = ((DeclaredType)element.asType()).asElement().asType();
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                Set<? extends ExecutableElement> keySet = elementValues.keySet();
                for (ExecutableElement executableElement : keySet) {
                    String key = executableElement.getSimpleName().toString();
                    if ("type".equals(key)) {
                        type = elementValues.get(executableElement).getValue().toString();
                        continue;
                    }
                    if ("tag".equals(key)) {
                        tag = elementValues.get(executableElement).toString();
                        continue;
                    }
                    if (!"presenterId".equals(key)) continue;
                    presenterId = elementValues.get(executableElement).toString();
                }
                Field field = new Field(clazz, name, type, tag, presenterId);
                fields.add(field);
                continue block0;
            }
        }
        return fields;
    }

    private List<PresenterProvider> collectPresenterProviders(TypeElement presentersContainer) {
        ArrayList<PresenterProvider> providers = new ArrayList<PresenterProvider>();
        block0: for (Element element : presentersContainer.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement providerMethod = (ExecutableElement)element;
            for (AnnotationMirror annotationMirror : providerMethod.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().toString().equals(PROVIDE_PRESENTER) || providerMethod.getReturnType().getKind() != TypeKind.DECLARED) continue;
                DeclaredType kind = (DeclaredType)providerMethod.getReturnType();
                String type = null;
                String tag = null;
                String presenterId = null;
                String name = providerMethod.getSimpleName().toString();
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                Set<? extends ExecutableElement> keySet = elementValues.keySet();
                for (ExecutableElement executableElement : keySet) {
                    String key = executableElement.getSimpleName().toString();
                    if ("type".equals(key)) {
                        type = elementValues.get(executableElement).getValue().toString();
                        continue;
                    }
                    if ("tag".equals(key)) {
                        tag = elementValues.get(executableElement).toString();
                        continue;
                    }
                    if (!"presenterId".equals(key)) continue;
                    presenterId = elementValues.get(executableElement).toString();
                }
                PresenterProvider provider = new PresenterProvider(kind, name, type, tag, presenterId);
                providers.add(provider);
                continue block0;
            }
        }
        return providers;
    }

    private List<TagProvider> collectTagProviders(TypeElement presentersContainer) {
        ArrayList<TagProvider> providers = new ArrayList<TagProvider>();
        block0: for (Element element : presentersContainer.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement providerMethod = (ExecutableElement)element;
            for (AnnotationMirror annotationMirror : providerMethod.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().toString().equals(PROVIDE_PRESENTER_TAG) || providerMethod.getReturnType().getKind() != TypeKind.DECLARED) continue;
                DeclaredType kind = null;
                String type = null;
                String presenterId = null;
                String name = providerMethod.getSimpleName().toString();
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                Set<? extends ExecutableElement> keySet = elementValues.keySet();
                for (ExecutableElement executableElement : keySet) {
                    String key = executableElement.getSimpleName().toString();
                    if ("presenterClass".equals(key)) {
                        kind = (DeclaredType)elementValues.get(executableElement).getValue();
                        continue;
                    }
                    if ("type".equals(key)) {
                        type = elementValues.get(executableElement).getValue().toString();
                        continue;
                    }
                    if (!"presenterId".equals(key)) continue;
                    presenterId = elementValues.get(executableElement).toString();
                }
                TagProvider provider = new TagProvider(kind, name, type, presenterId);
                providers.add(provider);
                continue block0;
            }
        }
        return providers;
    }

    public Set<TypeElement> getPresentersContainers() {
        return this.mPresentersContainers;
    }

    private static String generateGetPresentersMethod(String builder, List<Field> fields, String parentClassName) {
        String s = "\tpublic List<PresenterField<" + parentClassName + ">> getPresenterFields() {\n" + "\t\tList<PresenterField<" + parentClassName + ">> presenters = new ArrayList<>();\n" + "\n";
        for (Field field : fields) {
            s = s + "\t\tpresenters.add(new " + field.getGeneratedClassName() + "());\n";
        }
        s = s + "\n\t\treturn presenters;\n\t}\n\n";
        return builder + s;
    }

    private static String generatePresenterBinderClass(String builder, String targetClass, Field field) {
        TypeElement clazz = (TypeElement)((DeclaredType)field.getClazz()).asElement();
        String tag = field.getTag();
        tag = tag != null ? tag : "\"" + field.getName() + "\"";
        String s = "\tpublic class " + field.getGeneratedClassName() + " extends PresenterField<" + targetClass + "> {\n" + "\t\tpublic " + field.getGeneratedClassName() + "() {\n" + "\t\t\tsuper(" + tag + ", PresenterType." + field.getType().name() + ", " + field.getPresenterId() + ", " + clazz + ".class);\n" + "\t\t}\n" + "\n" + "\t\t@Override\n" + "\t\tpublic void bind(" + targetClass + " target, MvpPresenter presenter) {\n" + "\t\t\ttarget." + field.getName() + " = (" + clazz.getQualifiedName() + ") presenter;\n" + "\t\t}\n";
        s = s + "\n\t\t@Override\n\t\tpublic MvpPresenter<?> providePresenter(" + targetClass + " delegated) {\n";
        if (field.getPresenterProviderMethodName() != null) {
            s = s + "\t\t\treturn delegated." + field.getPresenterProviderMethodName() + "();\n";
        } else {
            boolean hasEmptyConstructor = false;
            List<? extends Element> enclosedElements = clazz.getEnclosedElements();
            for (Element element : enclosedElements) {
                List<? extends VariableElement> parameters;
                if (element.getKind() != ElementKind.CONSTRUCTOR || (parameters = ((ExecutableElement)element).getParameters()) != null && !parameters.isEmpty()) continue;
                hasEmptyConstructor = true;
                break;
            }
            s = hasEmptyConstructor ? s + "\t\t\treturn new " + clazz.getQualifiedName() + "();\n" : s + "\t\t\tthrow new IllegalStateException(\"" + clazz.getSimpleName() + " has not default constructor. You can apply @ProvidePresenter to some method which will construct Presenter. Also you can make it default constructor\");\n";
        }
        s = s + "\t\t}\n";
        if (field.getPresenterTagProviderMethodName() != null) {
            s = s + "\n\t\t@Override\n\t\tpublic String getTag(" + targetClass + " delegated) {\n" + "\t\t\treturn String.valueOf(delegated." + field.getPresenterTagProviderMethodName() + "());\n" + "\t\t}\n";
        }
        s = s + "\t}\n\n";
        return builder + s;
    }

    private class TagProvider {
        private final DeclaredType mPresenterClass;
        private final String mMethodName;
        private final PresenterType mType;
        private final String mPresenterId;

        public TagProvider(DeclaredType presenterClass, String methodName, String type, String presenterId) {
            this.mPresenterClass = presenterClass;
            this.mMethodName = methodName;
            this.mType = type == null ? PresenterType.LOCAL : PresenterType.valueOf((String)type);
            this.mPresenterId = presenterId;
        }
    }

    private class PresenterProvider {
        private final DeclaredType mClazz;
        private final String mName;
        private final PresenterType mType;
        private final String mTag;
        private final String mPresenterId;

        public PresenterProvider(DeclaredType clazz, String name, String type, String tag, String presenterId) {
            this.mClazz = clazz;
            this.mName = name;
            this.mType = type == null ? PresenterType.LOCAL : PresenterType.valueOf((String)type);
            this.mTag = tag;
            this.mPresenterId = presenterId;
        }

        public String toString() {
            return "PresenterProvider{mPresenterClass=" + this.mClazz + ", mMethodName='" + this.mName + '\'' + ", mType=" + this.mType + ", mTag='" + this.mTag + '\'' + ", mPresenterId='" + this.mPresenterId + '\'' + '}';
        }
    }

    private static class Field {
        private final TypeMirror mClazz;
        private final String mName;
        private final PresenterType mType;
        private final String mTag;
        private final String mPresenterId;
        private String mPresenterProviderMethodName;
        private String mPresenterTagProviderMethodName;

        Field(TypeMirror clazz, String name, String type, String tag, String presenterId) {
            this.mClazz = clazz;
            this.mName = name;
            this.mTag = tag;
            this.mType = type == null ? PresenterType.LOCAL : PresenterType.valueOf((String)type);
            this.mPresenterId = presenterId;
        }

        public TypeMirror getClazz() {
            return this.mClazz;
        }

        public String getGeneratedClassName() {
            return this.mName + "Binder";
        }

        public String getTag() {
            return this.mTag;
        }

        public String getName() {
            return this.mName;
        }

        public PresenterType getType() {
            return this.mType;
        }

        public String getPresenterId() {
            return this.mPresenterId;
        }

        public String getPresenterProviderMethodName() {
            return this.mPresenterProviderMethodName;
        }

        public void setPresenterProviderMethodName(String presenterProviderMethodName) {
            this.mPresenterProviderMethodName = presenterProviderMethodName;
        }

        public String getPresenterTagProviderMethodName() {
            return this.mPresenterTagProviderMethodName;
        }

        public void setPresenterTagProviderMethodName(String presenterTagProviderMethodName) {
            this.mPresenterTagProviderMethodName = presenterTagProviderMethodName;
        }

        public String toString() {
            return "Field{mPresenterClass=" + this.mClazz + ", mMethodName='" + this.mName + '\'' + ", mType=" + this.mType + ", mTag='" + this.mTag + '\'' + ", mPresenterId='" + this.mPresenterId + '\'' + ", mPresenterProviderMethodName='" + this.mPresenterProviderMethodName + '\'' + '}';
        }
    }
}

