/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.udp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.ApplicationLayer;

public class Udp
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    private Udp(Builder builder) {
        this.header = new Header(builder);
        this.payload = ApplicationLayer.valueOf((short)((Short)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Udp Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private short sourcePort;
        private short destinationPort;
        private short length;
        private short checksum;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder sourcePort(int sourcePort) {
            this.sourcePort = (short)(sourcePort & 0xFFFF);
            return this;
        }

        public Builder destinationPort(int destinationPort) {
            this.destinationPort = (short)(destinationPort & 0xFFFF);
            return this;
        }

        public Builder length(int length) {
            this.length = (short)(length & 0xFFFF);
            return this;
        }

        public Builder checksum(int checksum) {
            this.checksum = (short)(checksum & 0xFFFF);
            return this;
        }

        public Builder payloadBuffer(Memory payloadBuffer) {
            this.payloadBuffer = payloadBuffer;
            return this;
        }

        public Packet build() {
            return new Udp(this);
        }

        public Packet build(Memory buffer) {
            this.sourcePort = buffer.readShort();
            this.destinationPort = buffer.readShort();
            this.length = buffer.readShort();
            this.checksum = buffer.readShort();
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Udp(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 8);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.sourcePort >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.destinationPort >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.length >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.checksum >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setShort(index, (int)this.sourcePort);
                this.buffer.setShort(index += 2, (int)this.destinationPort);
                this.buffer.setShort(index += 2, (int)this.length);
                this.buffer.setShort(index += 2, (int)this.checksum);
            }
        }
    }

    public static class Header
    extends AbstractPacket.Header {
        public static final int UDP_HEADER_LENGTH = 8;
        private final short sourcePort;
        private final short destinationPort;
        private final short length;
        private final short checksum;
        private final Builder builder;

        private Header(Builder builder) {
            this.sourcePort = builder.sourcePort;
            this.destinationPort = builder.destinationPort;
            this.length = builder.length;
            this.checksum = builder.checksum;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        public int getSourcePort() {
            return this.sourcePort & 0xFFFF;
        }

        public int getDestinationPort() {
            return this.destinationPort & 0xFFFF;
        }

        public int getChecksum() {
            return this.checksum & 0xFFFF;
        }

        public ApplicationLayer getPayloadType() {
            return ApplicationLayer.valueOf((short)this.destinationPort);
        }

        public int getLength() {
            return 8;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeShort((int)this.sourcePort);
                this.buffer.writeShort((int)this.destinationPort);
                this.buffer.writeShort((int)this.length);
                this.buffer.writeShort((int)this.checksum);
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\tsourcePort: " + this.sourcePort + '\n' + "\tdestinationPort: " + this.destinationPort + '\n' + "\tlength: " + this.length + '\n' + "\tchecksum: " + this.checksum + '\n';
        }
    }
}

