/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.tcp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.Strings;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.ApplicationLayer;
import com.ardikars.jxpacket.core.tcp.TcpFlags;

public class Tcp
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    private Tcp(Builder builder) {
        this.header = new Header(builder);
        this.payload = ApplicationLayer.valueOf((short)((Short)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Tcp Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private short sourcePort;
        private short destinationPort;
        private int sequence;
        private int acknowledge;
        private byte dataOffset;
        private TcpFlags flags;
        private short windowSize;
        private short checksum;
        private short urgentPointer;
        private byte[] options;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder sourcePort(int sourcePort) {
            this.sourcePort = (short)(sourcePort & 0xFFFF);
            return this;
        }

        public Builder destinationPort(int destinationPort) {
            this.destinationPort = (short)(destinationPort & 0xFFFF);
            return this;
        }

        public Builder sequence(int sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder acknowledge(int acknowledge) {
            this.acknowledge = acknowledge;
            return this;
        }

        public Builder dataOffset(int dataOffset) {
            this.dataOffset = (byte)(dataOffset & 0xF);
            return this;
        }

        public Builder flags(TcpFlags flags) {
            this.flags = flags;
            return this;
        }

        public Builder windowsSize(int windowSize) {
            this.windowSize = (short)(windowSize & 0xFFFF);
            return this;
        }

        public Builder checksum(int checksum) {
            this.checksum = (short)(checksum & 0xFFFF);
            return this;
        }

        public Builder urgentPointer(int urgentPointer) {
            this.urgentPointer = (short)(urgentPointer & 0xFFFF);
            return this;
        }

        public Builder options(byte[] options) {
            this.options = (byte[])Validate.nullPointer((Object)options, (Object)new byte[0]);
            return this;
        }

        public Builder payloadBuffer(Memory buffer) {
            this.payloadBuffer = buffer;
            return this;
        }

        public Packet build() {
            return new Tcp(this);
        }

        public Packet build(Memory buffer) {
            this.sourcePort = buffer.readShort();
            this.destinationPort = buffer.readShort();
            this.sequence = buffer.readInt();
            this.acknowledge = buffer.readInt();
            short flags = buffer.readShort();
            this.dataOffset = (byte)(flags >> 12 & 0xF);
            this.flags = new TcpFlags.Builder().build((short)(flags & 0x1FF));
            this.windowSize = buffer.readShort();
            this.checksum = buffer.readShort();
            this.urgentPointer = buffer.readShort();
            if (this.dataOffset > 5) {
                int optionLength = (this.dataOffset << 2) - 20;
                if (buffer.capacity() < 20 + optionLength) {
                    optionLength = buffer.capacity() - 20;
                }
                this.options = new byte[optionLength];
                buffer.readBytes(this.options);
                int length = 20 + optionLength;
                this.payloadBuffer = buffer.copy(length, buffer.capacity() - length);
            }
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Tcp(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 20);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.sourcePort >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.destinationPort >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.sequence >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.acknowledge >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.flags != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.windowSize >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.checksum >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.urgentPointer >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.dataOffset >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.options != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setShort(index, (int)this.sourcePort);
                this.buffer.setShort(index += 2, (int)this.destinationPort);
                this.buffer.setInt(index += 2, this.sequence);
                this.buffer.setInt(index += 4, this.acknowledge);
                int tmp = this.dataOffset << 12 & 0xF | this.flags.getShortValue() & 0x1FF;
                this.buffer.setShort(index += 4, tmp);
                this.buffer.setShort(index += 2, (int)this.windowSize);
                this.buffer.setShort(index += 2, (int)this.checksum);
                this.buffer.setShort(index += 2, (int)this.urgentPointer);
                index += 2;
                if (this.dataOffset > 5 && this.options != null) {
                    this.buffer.setBytes(index, this.options);
                }
            }
        }
    }

    public static final class Header
    extends AbstractPacket.Header {
        public static final int TCP_HEADER_LENGTH = 20;
        private final short sourcePort;
        private final short destinationPort;
        private final int sequence;
        private final int acknowledge;
        private final byte dataOffset;
        private final TcpFlags flags;
        private final short windowSize;
        private final short checksum;
        private final short urgentPointer;
        private final byte[] options;
        private final Builder builder;

        private Header(Builder builder) {
            this.sourcePort = builder.sourcePort;
            this.destinationPort = builder.destinationPort;
            this.sequence = builder.sequence;
            this.acknowledge = builder.acknowledge;
            this.dataOffset = builder.dataOffset;
            this.flags = builder.flags;
            this.windowSize = builder.windowSize;
            this.checksum = builder.checksum;
            this.urgentPointer = builder.urgentPointer;
            this.options = builder.options;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        public int getSourcePort() {
            return this.sourcePort & 0xFFFF;
        }

        public int getDestinationPort() {
            return this.destinationPort & 0xFFFF;
        }

        public int getSequence() {
            return this.sequence;
        }

        public int getAcknowledge() {
            return this.acknowledge;
        }

        public int getDataOffset() {
            return this.dataOffset & 0xF;
        }

        public TcpFlags getFlags() {
            return this.flags;
        }

        public int getWindowSize() {
            return this.windowSize & 0xFFFF;
        }

        public int getChecksum() {
            return this.checksum & 0xFFFF;
        }

        public int getUrgentPointer() {
            return this.urgentPointer & 0xFFFF;
        }

        public byte[] getOptions() {
            if (this.options == null) {
                return new byte[0];
            }
            byte[] buffer = new byte[this.options.length];
            System.arraycopy(this.options, 0, buffer, 0, buffer.length);
            return buffer;
        }

        public ApplicationLayer getPayloadType() {
            return ApplicationLayer.valueOf((short)this.destinationPort);
        }

        public int getLength() {
            int length = 20;
            if (this.options != null) {
                length += this.options.length;
            }
            return length;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeShort((int)this.sourcePort);
                this.buffer.writeShort((int)this.destinationPort);
                this.buffer.writeInt(this.sequence);
                this.buffer.writeInt(this.acknowledge);
                this.buffer.writeShort(this.flags.getShortValue() & 0x1FF | (this.dataOffset & 0xF) << 12);
                this.buffer.writeShort((int)this.windowSize);
                this.buffer.writeShort((int)this.checksum);
                this.buffer.writeShort((int)this.urgentPointer);
                if (this.options != null) {
                    this.buffer.writeBytes(this.options);
                }
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\tsourcePort: " + this.sourcePort + '\n' + "\tdestinationPort: " + this.destinationPort + '\n' + "\tsequence: " + this.sequence + '\n' + "\tacknowledge: " + this.acknowledge + '\n' + "\tdataOffset: " + this.dataOffset + '\n' + "\tflags: " + this.flags + '\n' + "\twindowSize: " + this.windowSize + '\n' + "\tchecksum: " + this.checksum + '\n' + "\turgentPointer: " + this.urgentPointer + '\n' + "\toptions: " + Strings.toHexString((byte[])this.options) + '\n';
        }
    }
}

