/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ndp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import com.ardikars.jxpacket.core.ndp.NeighborDiscoveryOptions;

public class RouterSolicitation
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    public RouterSolicitation(Builder builder) {
        this.header = new Header(builder);
        this.payload = null;
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ RouterSolicitation Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private NeighborDiscoveryOptions options;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder options(NeighborDiscoveryOptions options) {
            this.options = options;
            return this;
        }

        public Packet build() {
            return new RouterSolicitation(this);
        }

        public Packet build(Memory buffer) {
            buffer.readInt();
            this.options = (NeighborDiscoveryOptions)new NeighborDiscoveryOptions.Builder().build(buffer);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new RouterSolicitation(this);
        }
    }

    public static class Header
    extends AbstractPacket.Header {
        public static final int ROUTER_SOLICITATION_HEADER_LENGTH = 4;
        private final NeighborDiscoveryOptions options;
        private final Builder builder;

        public Header(Builder builder) {
            this.options = builder.options;
            this.buffer = builder.buffer.slice(0, 4 + this.options.getHeader().getLength());
            this.builder = builder;
        }

        public NeighborDiscoveryOptions getOptions() {
            return this.options;
        }

        public <T extends NamedNumber> T getPayloadType() {
            return (T)UnknownPacket.UNKNOWN_PAYLOAD_TYPE;
        }

        public int getLength() {
            return 4 + this.options.getHeader().getLength();
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeInt(0);
                this.buffer.writeBytes(this.options.getHeader().getBuffer());
            }
            return this.buffer;
        }

        public AbstractPacket.Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\toptions: " + (Object)((Object)this.options) + '\n';
        }
    }
}

