/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ndp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.core.ndp.NeighborDiscoveryOptions;

public class RouterAdvertisement
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    public RouterAdvertisement(Builder builder) {
        this.header = new Header(builder);
        this.payload = null;
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ RouterAdvertisement Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private byte currentHopLimit;
        private boolean manageFlag;
        private boolean otherFlag;
        private short routerLifetime;
        private int reachableTime;
        private int retransmitTimer;
        private NeighborDiscoveryOptions options;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder currentHopLimit(int currentHopLimit) {
            this.currentHopLimit = (byte)(currentHopLimit & 0xFF);
            return this;
        }

        public Builder manageFlag(boolean manageFlag) {
            this.manageFlag = manageFlag;
            return this;
        }

        public Builder otherFlag(boolean otherFlag) {
            this.otherFlag = otherFlag;
            return this;
        }

        public Builder routerLifetime(int routerLifetime) {
            this.routerLifetime = (short)(routerLifetime & 0xFFFF);
            return this;
        }

        public Builder reachableTime(int reachableTime) {
            this.reachableTime = reachableTime;
            return this;
        }

        public Builder retransmitTimer(int retransmitTimer) {
            this.retransmitTimer = retransmitTimer;
            return this;
        }

        public Builder options(NeighborDiscoveryOptions options) {
            this.options = options;
            return this;
        }

        public Packet build() {
            return new RouterAdvertisement(this);
        }

        public Packet build(Memory buffer) {
            this.currentHopLimit = buffer.readByte();
            byte bscratch = buffer.readByte();
            this.manageFlag = (bscratch >> 7 & 1) == 1;
            this.otherFlag = (bscratch >> 6 & 1) == 1;
            this.routerLifetime = buffer.readShort();
            this.reachableTime = buffer.readInt();
            this.retransmitTimer = buffer.readInt();
            this.options = (NeighborDiscoveryOptions)new NeighborDiscoveryOptions.Builder().build(buffer);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new RouterAdvertisement(this);
        }
    }

    public static class Header
    extends AbstractPacket.Header {
        public static final int ROUTER_ADVERTISEMENT_HEADER_LENGTH = 12;
        private final byte currentHopLimit;
        private final boolean manageFlag;
        private final boolean otherFlag;
        private final short routerLifetime;
        private final int reachableTime;
        private final int retransmitTimer;
        private final NeighborDiscoveryOptions options;
        private final Builder builder;

        private Header(Builder builder) {
            this.currentHopLimit = builder.currentHopLimit;
            this.manageFlag = builder.manageFlag;
            this.otherFlag = builder.otherFlag;
            this.routerLifetime = builder.routerLifetime;
            this.reachableTime = builder.reachableTime;
            this.retransmitTimer = builder.retransmitTimer;
            this.options = builder.options;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        public int getCurrentHopLimit() {
            return this.currentHopLimit & 0xFF;
        }

        public boolean isManageFlag() {
            return this.manageFlag;
        }

        public boolean isOtherFlag() {
            return this.otherFlag;
        }

        public int getRouterLifetime() {
            return this.routerLifetime & 0xFFFF;
        }

        public int getReachableTime() {
            return this.reachableTime;
        }

        public int getRetransmitTimer() {
            return this.retransmitTimer;
        }

        public NeighborDiscoveryOptions getOptions() {
            return this.options;
        }

        public <T extends NamedNumber> T getPayloadType() {
            return null;
        }

        public int getLength() {
            return 12 + this.options.getHeader().getLength();
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeByte((int)this.currentHopLimit);
                this.buffer.writeByte((this.manageFlag ? 1 : 0) << 7 | (this.otherFlag ? 1 : 0) << 6);
                this.buffer.writeShort((int)this.routerLifetime);
                this.buffer.writeInt(this.reachableTime);
                this.buffer.writeInt(this.retransmitTimer);
                this.buffer.writeBytes(this.options.getHeader().getBuffer());
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\tcurrentHopLimit: " + this.currentHopLimit + '\n' + "\tmanageFlag: " + this.manageFlag + '\n' + "\totherFlag: " + this.otherFlag + '\n' + "\trouterLifetime: " + this.routerLifetime + '\n' + "\treachableTime: " + this.reachableTime + '\n' + "\tretransmitTimer: " + this.retransmitTimer + '\n' + "\toptions: " + (Object)((Object)this.options) + '\n';
        }
    }
}

