/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ndp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.net.Inet6Address;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import com.ardikars.jxpacket.core.ndp.NeighborDiscoveryOptions;

public class NeighborAdvertisement
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    public NeighborAdvertisement(Builder builder) {
        this.header = new Header(builder);
        this.payload = null;
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ NeighborAdvertisement Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private boolean routerFlag;
        private boolean solicitedFlag;
        private boolean overrideFlag;
        private Inet6Address targetAddress;
        private NeighborDiscoveryOptions options;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder routerFlag(boolean routerFlag) {
            this.routerFlag = routerFlag;
            return this;
        }

        public Builder solicitedFlag(boolean solicitedFlag) {
            this.solicitedFlag = solicitedFlag;
            return this;
        }

        public Builder overrideFlag(boolean overrideFlag) {
            this.overrideFlag = overrideFlag;
            return this;
        }

        public Builder targetAddress(Inet6Address targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        public Builder options(NeighborDiscoveryOptions options) {
            this.options = options;
            return this;
        }

        public Packet build() {
            return new NeighborAdvertisement(this);
        }

        public Packet build(Memory buffer) {
            int iscratch = buffer.readInt();
            this.routerFlag = (iscratch >> 31 & 1) == 1;
            this.solicitedFlag = (iscratch >> 30 & 1) == 1;
            this.overrideFlag = (iscratch >> 29 & 1) == 1;
            byte[] ipv6AddrBuffer = new byte[16];
            buffer.readBytes(ipv6AddrBuffer);
            this.targetAddress = Inet6Address.valueOf((byte[])ipv6AddrBuffer);
            this.options = (NeighborDiscoveryOptions)new NeighborDiscoveryOptions.Builder().build(buffer);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new NeighborAdvertisement(this);
        }
    }

    public static final class Header
    extends AbstractPacket.Header {
        public static final int HEADER_LENGTH = 20;
        private final boolean routerFlag;
        private final boolean solicitedFlag;
        private final boolean overrideFlag;
        private final Inet6Address targetAddress;
        private final NeighborDiscoveryOptions options;
        private final Builder builder;

        private Header(Builder builder) {
            this.routerFlag = builder.routerFlag;
            this.solicitedFlag = builder.solicitedFlag;
            this.overrideFlag = builder.overrideFlag;
            this.targetAddress = builder.targetAddress;
            this.options = builder.options;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        public boolean isRouterFlag() {
            return this.routerFlag;
        }

        public boolean isSolicitedFlag() {
            return this.solicitedFlag;
        }

        public boolean isOverrideFlag() {
            return this.overrideFlag;
        }

        public Inet6Address getTargetAddress() {
            return this.targetAddress;
        }

        public NeighborDiscoveryOptions getOptions() {
            return this.options;
        }

        public <T extends NamedNumber> T getPayloadType() {
            return (T)UnknownPacket.UNKNOWN_PAYLOAD_TYPE;
        }

        public int getLength() {
            return 20 + this.options.getHeader().getLength();
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeInt((this.routerFlag ? 1 : 0) << 31 | (this.solicitedFlag ? 1 : 0) << 30 | (this.overrideFlag ? 1 : 0) << 29);
                this.buffer.writeBytes(this.targetAddress.getAddress());
                this.buffer.writeBytes(this.options.getHeader().getBuffer());
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\trouterFlag: " + this.routerFlag + '\n' + "\tsolicitedFlag: " + this.solicitedFlag + '\n' + "\toverrideFlag: " + this.overrideFlag + '\n' + "\ttargetAddress: " + this.targetAddress + '\n' + "\toptions: " + (Object)((Object)this.options) + '\n';
        }
    }
}

