/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ip.ip6;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.TransportLayer;
import com.ardikars.jxpacket.core.ip.ip6.Options;

public class HopByHopOptions
extends Options {
    private final Header header;
    private final Packet payload;

    private HopByHopOptions(Builder builder) {
        this.header = new Header(builder);
        this.payload = TransportLayer.valueOf((Byte)((Byte)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "\t[ HopByHopOptions Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\t\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static final class Builder
    extends Options.Builder {
        public Builder() {
            super(TransportLayer.IPV6_HOPOPT);
        }

        public HopByHopOptions build() {
            return new HopByHopOptions(this);
        }

        public HopByHopOptions build(Memory buffer) {
            this.nextHeader = TransportLayer.valueOf((Byte)buffer.readByte());
            this.extensionLength = buffer.readByte();
            this.options = new byte[6 + 8 * this.extensionLength];
            buffer.readBytes(this.options);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new HopByHopOptions(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 6);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.nextHeader != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.extensionLength >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.options != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setByte(index, (int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.setByte(++index, this.extensionLength);
                this.buffer.setBytes(++index, this.options);
            }
        }
    }

    public static final class Header
    extends Options.Header {
        private final Builder builder;

        protected Header(Builder builder) {
            super(builder, builder.nextHeader);
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        public Builder getBuilder() {
            return this.builder;
        }
    }
}

