/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ip.ip6;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.TransportLayer;
import java.util.HashMap;
import java.util.Map;

public class Fragment
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    private Fragment(Builder builder) {
        this.header = new Header(builder);
        this.payload = TransportLayer.valueOf((Byte)((Byte)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Packet.Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "\t[ Fragment Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\t\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static final class FlagType
    extends NamedNumber<Byte, FlagType> {
        public static final FlagType LAST_FRAGMENT = new FlagType((byte)0, "Last fragment.");
        public static final FlagType MORE_FRAGMENT = new FlagType((byte)1, "More fragment.");
        public static final FlagType UNKNOWN = new FlagType((byte)-1, "UNKNOWN.");
        private static final Map<Byte, FlagType> registry = new HashMap<Byte, FlagType>();

        protected FlagType(Byte value, String name) {
            super((Number)value, name);
        }

        public static FlagType register(FlagType flagType) {
            registry.put((Byte)flagType.getValue(), flagType);
            return flagType;
        }

        public static FlagType valueOf(byte flag) {
            FlagType flagType = registry.get(flag);
            if (flagType == null) {
                return UNKNOWN;
            }
            return flagType;
        }
    }

    public static final class Builder
    extends AbstractPacket.Builder {
        private TransportLayer nextHeader;
        private short fragmentOffset;
        private FlagType flagType;
        private int identification;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder nextHeader(TransportLayer nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder fragmentOffset(int fragmentOffset) {
            this.fragmentOffset = (short)(fragmentOffset & 0x1FFF);
            return this;
        }

        public Builder flagType(FlagType flagType) {
            this.flagType = flagType;
            return this;
        }

        public Builder identification(int identification) {
            this.identification = identification;
            return this;
        }

        public Fragment build() {
            return new Fragment(this);
        }

        public Fragment build(Memory buffer) {
            this.nextHeader = TransportLayer.valueOf((Byte)buffer.readByte());
            buffer.readByte();
            short sscratch = buffer.readShort();
            this.fragmentOffset = (short)(sscratch >> 3 & 0x1FFF);
            this.flagType = FlagType.valueOf((byte)(sscratch & 1));
            this.identification = buffer.readInt();
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Fragment(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 8);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.nextHeader != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.fragmentOffset >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.flagType != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.identification >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setByte(index, (int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.setByte(++index, 0);
                int sscratch = (this.fragmentOffset & 0x1FFF) << 3 | (Byte)this.flagType.getValue() & 1;
                this.buffer.setShort(++index, sscratch);
                this.buffer.setIndex(index += 2, this.identification);
            }
        }
    }

    public static final class Header
    extends AbstractPacket.Header {
        public static final int FIXED_FRAGMENT_HEADER_LENGTH = 8;
        private final TransportLayer nextHeader;
        private final short fragmentOffset;
        private final FlagType flagType;
        private final int identification;
        private final Builder builder;

        private Header(Builder builder) {
            this.nextHeader = builder.nextHeader;
            this.fragmentOffset = builder.fragmentOffset;
            this.flagType = builder.flagType;
            this.identification = builder.identification;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        public TransportLayer getNextHeader() {
            return this.nextHeader;
        }

        public int getFragmentOffset() {
            return this.fragmentOffset & 0x1FFF;
        }

        public FlagType getFlagType() {
            return this.flagType;
        }

        public int getIdentification() {
            return this.identification;
        }

        public TransportLayer getPayloadType() {
            return this.nextHeader;
        }

        public int getLength() {
            return 8;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeByte((int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.writeByte(0);
                this.buffer.writeShort((this.fragmentOffset & 0x1FFF) << 3 | (Byte)this.flagType.getValue() & 1);
                this.buffer.writeInt(this.identification);
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\t\tnextHeader: " + this.nextHeader + '\n' + "\t\tfragmentOffset: " + this.fragmentOffset + '\n' + "\t\tflagType: " + (Object)((Object)this.flagType) + '\n' + "\t\tidentification: " + this.identification + '\n';
        }
    }
}

