/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ip.ip6;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.Strings;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.TransportLayer;

public class Authentication
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    private Authentication(Builder builder) {
        this.header = new Header(builder);
        this.payload = TransportLayer.valueOf((Byte)((Byte)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Packet.Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "\t[ Authentication Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\t\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static final class Builder
    extends AbstractPacket.Builder {
        private TransportLayer nextHeader;
        private byte payloadLength;
        private int securityParameterIndex;
        private int sequenceNumber;
        private byte[] integrityCheckValue;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder nextHeader(TransportLayer nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder payloadLength(int payloadLength) {
            this.payloadLength = (byte)(payloadLength & 0xFF);
            return this;
        }

        public Builder securityParameterIndex(int securityParameterIndex) {
            this.securityParameterIndex = securityParameterIndex;
            return this;
        }

        public Builder sequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder integrityCheckValue(byte[] integrityCheckValue) {
            this.integrityCheckValue = new byte[integrityCheckValue.length];
            System.arraycopy(integrityCheckValue, 0, this.integrityCheckValue, 0, this.integrityCheckValue.length);
            return this;
        }

        public Packet build() {
            return new Authentication(this);
        }

        public Packet build(Memory buffer) {
            this.nextHeader = TransportLayer.valueOf((Byte)buffer.readByte());
            this.payloadLength = buffer.readByte();
            buffer.skipBytes(2);
            this.securityParameterIndex = buffer.readInt();
            this.sequenceNumber = buffer.readInt();
            this.integrityCheckValue = new byte[(this.payloadLength + 2) * 4 - 12];
            if (this.integrityCheckValue != null) {
                buffer.readBytes(this.integrityCheckValue);
            }
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Authentication(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 12);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.nextHeader != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.payloadLength >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.securityParameterIndex >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.sequenceNumber >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.integrityCheckValue != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setByte(index, (int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.setByte(++index, (int)this.payloadLength);
                this.buffer.setInt(++index, this.securityParameterIndex);
                this.buffer.setInt(index += 4, this.sequenceNumber);
                this.buffer.setBytes(index += 4, this.integrityCheckValue);
            }
        }
    }

    public static final class Header
    extends AbstractPacket.Header {
        public static final byte FIXED_HEADER_LENGTH = 12;
        private final TransportLayer nextHeader;
        private final byte payloadLength;
        private final int securityParameterIndex;
        private final int sequenceNumber;
        private final byte[] integrityCheckValue;
        private final Builder builder;

        private Header(Builder builder) {
            this.nextHeader = builder.nextHeader;
            this.payloadLength = builder.payloadLength;
            this.securityParameterIndex = builder.securityParameterIndex;
            this.sequenceNumber = builder.sequenceNumber;
            this.integrityCheckValue = builder.integrityCheckValue;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        public TransportLayer getNextHeader() {
            return this.nextHeader;
        }

        public int getPayloadLength() {
            return this.payloadLength & 0xFF;
        }

        public int getSecurityParameterIndex() {
            return this.securityParameterIndex;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public byte[] getIntegrityCheckValue() {
            byte[] integrityCheckValue = new byte[this.integrityCheckValue.length];
            System.arraycopy(this.integrityCheckValue, 0, integrityCheckValue, 0, this.integrityCheckValue.length);
            return integrityCheckValue;
        }

        public TransportLayer getPayloadType() {
            return this.nextHeader;
        }

        public int getLength() {
            return 12 + (this.integrityCheckValue == null ? 0 : this.integrityCheckValue.length);
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.setByte(0, (int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.setByte(1, (int)this.payloadLength);
                this.buffer.setShort(2, 0);
                this.buffer.setInt(4, this.sequenceNumber);
                this.buffer.setInt(8, this.securityParameterIndex);
                if (this.integrityCheckValue != null) {
                    this.buffer.setBytes(12, this.integrityCheckValue);
                }
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\t\tnextHeader: " + this.nextHeader + '\n' + "\t\tpayloadLength: " + this.payloadLength + '\n' + "\t\tsecurityParameterIndex: " + this.securityParameterIndex + '\n' + "\t\tsequenceNumber: " + this.sequenceNumber + '\n' + "\t\tintegrityCheckValue: " + Strings.toHexString((byte[])this.integrityCheckValue) + '\n';
        }
    }
}

