/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ip;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.net.Inet6Address;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.TransportLayer;
import com.ardikars.jxpacket.core.ip.Ip;

public class Ip6
extends Ip {
    private final Header header;
    private final Packet payload;

    private Ip6(Builder builder) {
        this.header = new Header(builder);
        this.payload = TransportLayer.valueOf((Byte)((Byte)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Ip6 Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static abstract class ExtensionHeader
    extends AbstractPacket.Header {
    }

    public static final class Builder
    extends Ip.AbstractPaketBuilder {
        private byte trafficClass;
        private int flowLabel;
        private short payloadLength;
        private TransportLayer nextHeader;
        private byte hopLimit;
        private Inet6Address sourceAddress;
        private Inet6Address destinationAddress;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder trafficClass(int trafficClass) {
            this.trafficClass = (byte)(trafficClass & 0xFF);
            return this;
        }

        public Builder flowLabel(int flowLabel) {
            this.flowLabel = flowLabel & 0xFFFFF;
            return this;
        }

        public Builder payloadLength(int payloadLength) {
            this.payloadLength = (short)(payloadLength & 0xFFFF);
            return this;
        }

        public Builder nextHeader(TransportLayer nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder hopLimit(int hopLimit) {
            this.hopLimit = (byte)(hopLimit & 0xFF);
            return this;
        }

        public Builder sourceAddress(Inet6Address sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public Builder destinationAddress(Inet6Address destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public Builder payloadBuffer(Memory buffer) {
            this.payloadBuffer = buffer;
            return this;
        }

        public Packet build() {
            return new Ip6(this);
        }

        public Packet build(Memory buffer) {
            int iscratch = buffer.readInt();
            this.trafficClass = (byte)(iscratch >> 20 & 0xFF);
            this.flowLabel = iscratch & 0xFFFFF;
            this.payloadLength = buffer.readShort();
            this.nextHeader = TransportLayer.valueOf((Byte)buffer.readByte());
            this.hopLimit = buffer.readByte();
            byte[] addrBuf = new byte[16];
            buffer.readBytes(addrBuf);
            this.sourceAddress = Inet6Address.valueOf((byte[])addrBuf);
            addrBuf = new byte[16];
            buffer.readBytes(addrBuf);
            this.destinationAddress = Inet6Address.valueOf((byte[])addrBuf);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Ip6(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 40);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.trafficClass >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.flowLabel >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.payloadLength >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.nextHeader != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.hopLimit >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.sourceAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.destinationAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                int scratch = this.trafficClass << 20 & 0xFF | this.flowLabel & 0xFFFFF;
                this.buffer.setInt(offset, scratch);
                index += 4;
                this.buffer.setShort(offset, (int)this.payloadLength);
                this.buffer.setByte(index += 2, (int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.setByte(++index, (int)this.hopLimit);
                this.buffer.setBytes(++index, this.sourceAddress.toBytes());
                this.buffer.setBytes(index += 16, this.destinationAddress.toBytes());
            }
        }
    }

    public static final class Header
    extends Ip.AbstractPacketHeader {
        public static final int IPV6_HEADER_LENGTH = 40;
        private final byte trafficClass;
        private final int flowLabel;
        private final short payloadLength;
        private final TransportLayer nextHeader;
        private final byte hopLimit;
        private final Inet6Address sourceAddress;
        private final Inet6Address destinationAddress;
        private final Builder builder;

        protected Header(Builder builder) {
            super((byte)6);
            this.trafficClass = builder.trafficClass;
            this.flowLabel = builder.flowLabel;
            this.payloadLength = builder.payloadLength;
            this.nextHeader = builder.nextHeader;
            this.hopLimit = builder.hopLimit;
            this.sourceAddress = builder.sourceAddress;
            this.destinationAddress = builder.destinationAddress;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        public int getTrafficClass() {
            return this.trafficClass & 0xFF;
        }

        public int getFlowLabel() {
            return this.flowLabel & 0xFFFFF;
        }

        public int getPayloadLength() {
            return this.payloadLength & 0xFFFF;
        }

        public TransportLayer getNextHeader() {
            return this.nextHeader;
        }

        public int getHopLimit() {
            return this.hopLimit & 0xFF;
        }

        public Inet6Address getSourceAddress() {
            return this.sourceAddress;
        }

        public Inet6Address getDestinationAddress() {
            return this.destinationAddress;
        }

        public TransportLayer getPayloadType() {
            return this.nextHeader;
        }

        public int getLength() {
            return 40;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeInt((this.version & 0xF) << 28 | (this.trafficClass & 0xFF) << 20 | this.flowLabel & 0xFFFFF);
                this.buffer.writeShort((int)this.payloadLength);
                this.buffer.writeByte((int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.writeByte((int)this.hopLimit);
                this.buffer.writeBytes(this.sourceAddress.toBytes());
                this.buffer.writeBytes(this.destinationAddress.toBytes());
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\tversion: " + this.version + '\n' + "\ttrafficClass: " + this.trafficClass + '\n' + "\tflowLabel: " + this.flowLabel + '\n' + "\tpayloadLength: " + this.payloadLength + '\n' + "\tnextHeader: " + this.nextHeader + '\n' + "\thopLimit: " + this.hopLimit + '\n' + "\tsourceAddress: " + this.sourceAddress + '\n' + "\tdestinationAddress: " + this.destinationAddress + '\n';
        }
    }
}

