/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.icmp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.core.icmp.Icmp;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6DestinationUnreachable;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6EchoReply;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6EchoRequest;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6HomeAgentAddressDiscoveryReply;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6HomeAgentAddressDiscoveryRequest;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6InverseNeighborDiscoveryAdvertisement;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6InverseNeighborDiscoverySolicitation;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6MobilePrefixAdvertisement;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6MobilePrefixSolicitation;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6MulticastListenerDone;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6MulticastListenerQuery;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6MulticastListenerReportV1;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6MulticastListenerReportV2;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6NeighborAdvertisement;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6NeighborSolicitation;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6NodeInformationQuery;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6NodeInformationResponse;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6PacketTooBigMessage;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6ParameterProblem;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6RedirectMessage;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6RouterAdvertisement;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6RouterRenumbering;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6RouterSolicitation;
import com.ardikars.jxpacket.core.icmp.icmp6.Icmp6TimeExceeded;
import java.util.Collection;
import java.util.HashSet;

public class Icmp6
extends AbstractPacket {
    public static final Collection<Icmp.IcmpTypeAndCode> ICMP6_REGISTRY = new HashSet<Icmp.IcmpTypeAndCode>();
    private final Header header;
    private final Packet payload;

    public Icmp6(Builder builder) {
        this.header = new Header(builder);
        this.payload = Icmp.IcmpTypeAndCode.valueOf(this.header.getPayloadType().getValue().byteValue()).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Icmp6 Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    static {
        try {
            Class.forName(Icmp6DestinationUnreachable.class.getName());
            Class.forName(Icmp6EchoReply.class.getName());
            Class.forName(Icmp6EchoRequest.class.getName());
            Class.forName(Icmp6HomeAgentAddressDiscoveryReply.class.getName());
            Class.forName(Icmp6HomeAgentAddressDiscoveryRequest.class.getName());
            Class.forName(Icmp6InverseNeighborDiscoveryAdvertisement.class.getName());
            Class.forName(Icmp6InverseNeighborDiscoverySolicitation.class.getName());
            Class.forName(Icmp6MobilePrefixAdvertisement.class.getName());
            Class.forName(Icmp6MobilePrefixSolicitation.class.getName());
            Class.forName(Icmp6MulticastListenerDone.class.getName());
            Class.forName(Icmp6MulticastListenerQuery.class.getName());
            Class.forName(Icmp6MulticastListenerReportV1.class.getName());
            Class.forName(Icmp6MulticastListenerReportV2.class.getName());
            Class.forName(Icmp6NeighborAdvertisement.class.getName());
            Class.forName(Icmp6NeighborSolicitation.class.getName());
            Class.forName(Icmp6NodeInformationQuery.class.getName());
            Class.forName(Icmp6NodeInformationResponse.class.getName());
            Class.forName(Icmp6PacketTooBigMessage.class.getName());
            Class.forName(Icmp6ParameterProblem.class.getName());
            Class.forName(Icmp6RedirectMessage.class.getName());
            Class.forName(Icmp6RouterAdvertisement.class.getName());
            Class.forName(Icmp6RouterRenumbering.class.getName());
            Class.forName(Icmp6RouterSolicitation.class.getName());
            Class.forName(Icmp6TimeExceeded.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static class Builder
    extends Icmp.AbstractPacketBuilder {
        private Memory buffer;
        private Memory payloadBuffer;

        public Packet build() {
            return new Icmp6(this);
        }

        public Packet build(Memory buffer) {
            byte type = buffer.readByte();
            byte code = buffer.readByte();
            this.typeAndCode = Icmp.findIcmpTypeAndCode(type, code, ICMP6_REGISTRY);
            this.checksum = buffer.readShort();
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Icmp6(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 4);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.typeAndCode != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.checksum >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setByte(index, (int)this.typeAndCode.getType());
                this.buffer.setByte(++index, (int)this.typeAndCode.getCode());
                this.buffer.setShort(++index, (int)this.checksum);
            }
        }
    }

    public static class Header
    extends Icmp.AbstractPacketHeader {
        private final Builder builder;

        private Header(Builder builder) {
            this.typeAndCode = builder.typeAndCode;
            this.checksum = builder.checksum;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        @Override
        public <T extends NamedNumber> T getPayloadType() {
            return (T)((Object)this.typeAndCode);
        }

        public String toString() {
            return "\ttypeAndCode: " + (Object)((Object)this.typeAndCode) + '\n' + "\tchecksum: " + this.checksum + '\n';
        }

        public AbstractPacket.Builder getBuilder() {
            return this.builder;
        }
    }
}

