/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.icmp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.core.icmp.Icmp;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4DestinationUnreachable;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4EchoReply;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4EchoRequest;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4ParameterProblem;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4RedirectMessage;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4RouterAdvertisement;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4RouterSolicitation;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4TimeExceeded;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4Timestamp;
import com.ardikars.jxpacket.core.icmp.icmp4.Icmp4TimestampReply;
import java.util.Collection;
import java.util.HashSet;

public class Icmp4
extends AbstractPacket {
    public static final Collection<Icmp.IcmpTypeAndCode> ICMP4_REGISTRY = new HashSet<Icmp.IcmpTypeAndCode>();
    private final Header header;
    private final Packet payload;

    private Icmp4(Builder builder) {
        this.header = new Header(builder);
        this.payload = Icmp.IcmpTypeAndCode.valueOf(this.header.getPayloadType().getValue().byteValue()).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Icmp4 Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    static {
        try {
            Class.forName(Icmp4DestinationUnreachable.class.getName());
            Class.forName(Icmp4EchoReply.class.getName());
            Class.forName(Icmp4EchoRequest.class.getName());
            Class.forName(Icmp4ParameterProblem.class.getName());
            Class.forName(Icmp4RedirectMessage.class.getName());
            Class.forName(Icmp4RouterAdvertisement.class.getName());
            Class.forName(Icmp4RouterSolicitation.class.getName());
            Class.forName(Icmp4TimeExceeded.class.getName());
            Class.forName(Icmp4Timestamp.class.getName());
            Class.forName(Icmp4TimestampReply.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static class Builder
    extends Icmp.AbstractPacketBuilder {
        private Memory buffer;
        private Memory payloadBuffer;
        private boolean calculateChecksum;

        private Builder calculateChecksum(boolean caculateChecksum) {
            this.calculateChecksum = caculateChecksum;
            return this;
        }

        public Packet build() {
            return new Icmp4(this);
        }

        public Packet build(Memory buffer) {
            byte type = buffer.readByte();
            byte code = buffer.readByte();
            this.typeAndCode = Icmp.findIcmpTypeAndCode(type, code, ICMP4_REGISTRY);
            this.checksum = buffer.readShort();
            if (this.calculateChecksum) {
                int index = 0;
                int accumulation = 0;
                for (int i = 0; i < buffer.capacity() / 2; ++i) {
                    accumulation += 0xFFFF & buffer.getShort(index);
                    index += 2;
                }
                if (buffer.capacity() % 2 > 0) {
                    accumulation += (buffer.getByte(index) & 0xFF) << 8;
                    ++index;
                }
                accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
                short checksum = (short)(~accumulation & 0xFFFF);
                this.checksum = buffer.readShort();
                if (checksum != this.checksum) {
                    this.checksum = 0;
                }
            }
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Icmp4(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 4);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.typeAndCode != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.checksum >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setByte(index, (int)this.typeAndCode.getType());
                this.buffer.setByte(++index, (int)this.typeAndCode.getCode());
                this.buffer.setShort(++index, (int)this.checksum);
            }
        }
    }

    public static class Header
    extends Icmp.AbstractPacketHeader {
        private final Builder builder;

        private Header(Builder builder) {
            this.typeAndCode = builder.typeAndCode;
            this.checksum = builder.checksum;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        @Override
        public <T extends NamedNumber> T getPayloadType() {
            return (T)((Object)this.typeAndCode);
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\ttypeAndCode: " + (Object)((Object)this.typeAndCode) + '\n' + "\tchecksum: " + this.checksum + '\n';
        }
    }
}

