/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ethernet;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.NetworkLayer;
import java.util.HashMap;
import java.util.Map;

public class Vlan
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    private Vlan(Builder builder) {
        this.header = new Header(builder);
        this.payload = NetworkLayer.valueOf((Short)((Short)this.header.getType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public static Vlan newPacket(Memory buffer) {
        return new Builder().build(buffer);
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Vlan Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static final class PriorityCodePoint
    extends NamedNumber<Byte, PriorityCodePoint> {
        public static final PriorityCodePoint BK = new PriorityCodePoint((byte)1, "Background (priority=0)");
        public static final PriorityCodePoint BE = new PriorityCodePoint((byte)0, "Best effort (default)/(priority=1)");
        public static final PriorityCodePoint EE = new PriorityCodePoint((byte)2, "Excellent effort (priority=2)");
        public static final PriorityCodePoint CA = new PriorityCodePoint((byte)3, "Critical applications (priority=3)");
        public static final PriorityCodePoint VI = new PriorityCodePoint((byte)4, "Video, < 100 ms latency and jitter (priority=4)");
        public static final PriorityCodePoint VO = new PriorityCodePoint((byte)5, "Voice, < 10 ms latency and jitter (priority=5)");
        public static final PriorityCodePoint IC = new PriorityCodePoint((byte)6, "Internetwork control (priority=6)");
        public static final PriorityCodePoint NC = new PriorityCodePoint((byte)7, "Network control (priority=7)");
        private static final Map<Byte, PriorityCodePoint> registry = new HashMap<Byte, PriorityCodePoint>();

        protected PriorityCodePoint(Byte value, String name) {
            super((Number)value, name);
        }

        public static PriorityCodePoint valueOf(byte value) {
            PriorityCodePoint priorityCodePoint = registry.get(value);
            if (priorityCodePoint == null) {
                return new PriorityCodePoint((byte)-1, "UNKONWN");
            }
            return priorityCodePoint;
        }

        public static PriorityCodePoint register(PriorityCodePoint priorityCodePoint) {
            registry.put((Byte)priorityCodePoint.getValue(), priorityCodePoint);
            return priorityCodePoint;
        }

        static {
            registry.put((Byte)BK.getValue(), BK);
            registry.put((Byte)BE.getValue(), BE);
            registry.put((Byte)EE.getValue(), EE);
            registry.put((Byte)CA.getValue(), CA);
            registry.put((Byte)VI.getValue(), VI);
            registry.put((Byte)VO.getValue(), VO);
            registry.put((Byte)IC.getValue(), IC);
            registry.put((Byte)NC.getValue(), NC);
        }
    }

    public static final class Builder
    extends AbstractPacket.Builder {
        private PriorityCodePoint priorityCodePoint;
        private byte canonicalFormatIndicator;
        private short vlanIdentifier;
        private NetworkLayer type;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder priorityCodePoint(PriorityCodePoint priorityCodePoint) {
            this.priorityCodePoint = priorityCodePoint;
            return this;
        }

        public Builder canonicalFormatIndicator(int canonicalFormatIndicator) {
            this.canonicalFormatIndicator = (byte)(canonicalFormatIndicator & 1);
            return this;
        }

        public Builder vlanIdentifier(int vlanIdentifier) {
            this.vlanIdentifier = (short)(vlanIdentifier & 0xFFF);
            return this;
        }

        public Builder type(NetworkLayer type) {
            this.type = type;
            return this;
        }

        public Builder payloadBuffer(Memory buffer) {
            this.payloadBuffer = buffer;
            return this;
        }

        public Vlan build() {
            return new Vlan(this);
        }

        public Vlan build(Memory buffer) {
            short tci = buffer.readShort();
            short type = buffer.readShort();
            this.priorityCodePoint = PriorityCodePoint.valueOf((byte)(tci >> 13 & 7));
            this.canonicalFormatIndicator = (byte)(tci >> 14 & 1);
            this.vlanIdentifier = (short)(tci & 0xFFF);
            this.type = NetworkLayer.valueOf((Short)type);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Vlan(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 4);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.priorityCodePoint != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.canonicalFormatIndicator >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.vlanIdentifier >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.type != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                int tci = (Byte)this.priorityCodePoint.getValue() << 13 & 7 | this.canonicalFormatIndicator << 14 & 1 | this.vlanIdentifier & 0xFFF;
                this.buffer.setShort(index, tci);
                this.buffer.setShort(index += 2, (int)((Short)this.type.getValue()).shortValue());
            }
        }
    }

    public static final class Header
    extends AbstractPacket.Header {
        public static final int VLAN_HEADER_LENGTH = 4;
        private final PriorityCodePoint priorityCodePoint;
        private final byte canonicalFormatIndicator;
        private final short vlanIdentifier;
        private final NetworkLayer type;
        private final Builder builder;

        private Header(Builder builder) {
            this.priorityCodePoint = builder.priorityCodePoint;
            this.canonicalFormatIndicator = builder.canonicalFormatIndicator;
            this.vlanIdentifier = builder.vlanIdentifier;
            this.type = builder.type;
            this.buffer = builder.buffer.slice(builder.buffer.readerIndex() - this.getLength(), this.getLength());
            this.builder = builder;
        }

        public PriorityCodePoint getPriorityCodePoint() {
            return this.priorityCodePoint;
        }

        public int getCanonicalFormatIndicator() {
            return this.canonicalFormatIndicator & 1;
        }

        public int getVlanIdentifier() {
            return this.vlanIdentifier & 0xFFF;
        }

        public NetworkLayer getType() {
            return this.type;
        }

        public NetworkLayer getPayloadType() {
            return this.type;
        }

        public int getLength() {
            return 4;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.setShort(0, (int)((Short)NetworkLayer.DOT1Q_VLAN_TAGGED_FRAMES.getValue()).shortValue());
                this.buffer.setShort(2, (Byte)this.priorityCodePoint.getValue() << 13 & 7 | this.canonicalFormatIndicator << 14 & 1 | this.vlanIdentifier & 0xFFF);
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\tpriorityCodePoint: " + (Object)((Object)this.priorityCodePoint) + '\n' + "\tcanonicalFormatIndicator: " + this.canonicalFormatIndicator + '\n' + "\tvlanIdentifier: " + this.vlanIdentifier + '\n' + "\ttype: " + this.type + '\n';
        }
    }
}

