/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.tcp;

import java.io.Serializable;

public final class TcpFlags
implements Serializable {
    private static final long serialVersionUID = -4085108976335127778L;
    private final boolean ns;
    private final boolean cwr;
    private final boolean ece;
    private final boolean urg;
    private final boolean ack;
    private final boolean psh;
    private final boolean rst;
    private final boolean syn;
    private final boolean fin;

    private TcpFlags(Builder builder) {
        this.ns = builder.ns;
        this.cwr = builder.cwr;
        this.ece = builder.ece;
        this.urg = builder.urg;
        this.ack = builder.ack;
        this.psh = builder.psh;
        this.rst = builder.rst;
        this.syn = builder.syn;
        this.fin = builder.fin;
    }

    public boolean isNs() {
        return this.ns;
    }

    public boolean isCwr() {
        return this.cwr;
    }

    public boolean isEce() {
        return this.ece;
    }

    public boolean isUrg() {
        return this.urg;
    }

    public boolean isAck() {
        return this.ack;
    }

    public boolean isPsh() {
        return this.psh;
    }

    public boolean isRst() {
        return this.rst;
    }

    public boolean isSyn() {
        return this.syn;
    }

    public boolean isFin() {
        return this.fin;
    }

    public short getShortValue() {
        short flags = 0;
        if (this.ns) {
            flags = (short)(flags + 256);
        }
        if (this.cwr) {
            flags = (short)(flags + 128);
        }
        if (this.ece) {
            flags = (short)(flags + 64);
        }
        if (this.urg) {
            flags = (short)(flags + 32);
        }
        if (this.ack) {
            flags = (short)(flags + 16);
        }
        if (this.psh) {
            flags = (short)(flags + 8);
        }
        if (this.rst) {
            flags = (short)(flags + 4);
        }
        if (this.syn) {
            flags = (short)(flags + 2);
        }
        if (this.fin) {
            flags = (short)(flags + 1);
        }
        return flags;
    }

    public String toString() {
        return "TcpFlags{" + "ns=" + this.isNs() + ", cwr=" + this.isCwr() + ", ece=" + this.isEce() + ", urg=" + this.isUrg() + ", ack=" + this.isAck() + ", psh=" + this.isPsh() + ", rst=" + this.isRst() + ", syn=" + this.isSyn() + ", fin=" + this.isFin() + '}';
    }

    public static final class Builder
    implements com.ardikars.common.util.Builder<TcpFlags, Short> {
        private boolean ns;
        private boolean cwr;
        private boolean ece;
        private boolean urg;
        private boolean ack;
        private boolean psh;
        private boolean rst;
        private boolean syn;
        private boolean fin;

        public Builder ns(boolean ns) {
            this.ns = ns;
            return this;
        }

        public Builder cwr(boolean cwr) {
            this.cwr = cwr;
            return this;
        }

        public Builder ece(boolean ece) {
            this.ece = ece;
            return this;
        }

        public Builder urg(boolean urg) {
            this.urg = urg;
            return this;
        }

        public Builder ack(boolean ack) {
            this.ack = ack;
            return this;
        }

        public Builder psh(boolean psh) {
            this.psh = psh;
            return this;
        }

        public Builder rst(boolean rst) {
            this.rst = rst;
            return this;
        }

        public Builder syn(boolean syn) {
            this.syn = syn;
            return this;
        }

        public Builder fin(boolean fin) {
            this.fin = false;
            return this;
        }

        public TcpFlags build() {
            return new TcpFlags(this);
        }

        public TcpFlags build(Short flags) {
            this.fin = (flags >> 0 & 1) == 1;
            this.syn = (flags >> 1 & 1) == 1;
            this.rst = (flags >> 2 & 1) == 1;
            this.psh = (flags >> 3 & 1) == 1;
            this.ack = (flags >> 4 & 1) == 1;
            this.urg = (flags >> 5 & 1) == 1;
            this.ece = (flags >> 6 & 1) == 1;
            this.cwr = (flags >> 7 & 1) == 1;
            this.ns = (flags >> 8 & 1) == 1;
            return new TcpFlags(this);
        }
    }
}

