/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ndp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.net.Inet6Address;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import com.ardikars.jxpacket.core.ndp.NeighborDiscoveryOptions;

public class Redirect
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    public Redirect(Builder builder) {
        this.header = new Header(builder);
        this.payload = null;
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Redirect Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private Inet6Address targetAddress;
        private Inet6Address destinationAddress;
        private NeighborDiscoveryOptions options;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder targetAddrss(Inet6Address targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        public Builder destinationAddress(Inet6Address destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public Packet build() {
            return new Redirect(this);
        }

        public Packet build(Memory buffer) {
            buffer.readInt();
            byte[] target = new byte[16];
            buffer.readBytes(target);
            this.targetAddress = Inet6Address.valueOf((byte[])target);
            byte[] destination = new byte[16];
            buffer.readBytes(destination);
            this.destinationAddress = Inet6Address.valueOf((byte[])destination);
            this.options = (NeighborDiscoveryOptions)new NeighborDiscoveryOptions.Builder().build(buffer);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Redirect(this);
        }
    }

    public static class Header
    extends AbstractPacket.Header {
        public static final byte REDIRECT_HEADER_LENGTH = 36;
        private final Inet6Address targetAddress;
        private final Inet6Address destinationAddress;
        private final NeighborDiscoveryOptions options;
        private final Builder builder;

        private Header(Builder builder) {
            this.targetAddress = builder.targetAddress;
            this.destinationAddress = builder.destinationAddress;
            this.options = builder.options;
            this.buffer = builder.buffer.slice(0, this.getLength());
            this.builder = builder;
        }

        public Inet6Address getTargetAddress() {
            return this.targetAddress;
        }

        public Inet6Address getDestinationAddress() {
            return this.destinationAddress;
        }

        public NeighborDiscoveryOptions getOptions() {
            return this.options;
        }

        public <T extends NamedNumber> T getPayloadType() {
            return (T)UnknownPacket.UNKNOWN_PAYLOAD_TYPE;
        }

        public int getLength() {
            return 36 + this.options.getHeader().getLength();
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeInt(0);
                this.buffer.writeBytes(this.targetAddress.getAddress());
                this.buffer.writeBytes(this.destinationAddress.getAddress());
                this.buffer.writeBytes(this.options.getHeader().getBuffer());
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\ttargetAddress: " + this.targetAddress + '\n' + "\tdestinationAddress: " + this.destinationAddress + '\n' + "\toptions: " + (Object)((Object)this.options) + '\n';
        }
    }
}

