/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ndp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.net.Inet6Address;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.core.ndp.NeighborDiscoveryOptions;

public class NeighborSolicitation
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    public NeighborSolicitation(Builder builder) {
        this.header = new Header(builder);
        this.payload = null;
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ NeighborSolicitation Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private Inet6Address targetAddress;
        private NeighborDiscoveryOptions options;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder targetAddress(Inet6Address targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        public Builder options(NeighborDiscoveryOptions options) {
            this.options = options;
            return this;
        }

        public Packet build() {
            return new NeighborSolicitation(this);
        }

        public Packet build(Memory buffer) {
            byte[] ipv6AddrBuffer = new byte[16];
            buffer.readBytes(ipv6AddrBuffer);
            this.targetAddress = Inet6Address.valueOf((byte[])ipv6AddrBuffer);
            this.options = (NeighborDiscoveryOptions)new NeighborDiscoveryOptions.Builder().build(buffer);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new NeighborSolicitation(this);
        }
    }

    public static class Header
    extends AbstractPacket.Header {
        public static final int NEIGHBOR_SOLICITATION_HEADER_LENGTH = 16;
        private final Inet6Address targetAddress;
        private final NeighborDiscoveryOptions options;
        private final Builder builder;

        private Header(Builder builder) {
            this.targetAddress = builder.targetAddress;
            this.options = builder.options;
            this.buffer = builder.buffer.slice(0, this.getLength());
            this.builder = builder;
        }

        public Inet6Address getTargetAddress() {
            return this.targetAddress;
        }

        public NeighborDiscoveryOptions getOptions() {
            return this.options;
        }

        public <T extends NamedNumber> T getPayloadType() {
            return null;
        }

        public int getLength() {
            return 16 + this.options.getHeader().getLength();
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeBytes(this.targetAddress.getAddress());
                this.buffer.writeBytes(this.options.getHeader().getBuffer());
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\ttargetAddress: " + this.targetAddress + '\n' + "\toptions: " + (Object)((Object)this.options) + '\n';
        }
    }
}

