/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ndp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NeighborDiscoveryOptions
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    public NeighborDiscoveryOptions(Builder builder) {
        this.header = new Header(builder);
        this.payload = null;
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ NeighborDiscoveryOptions Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private List<Option> options = new ArrayList<Option>();
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder options(List<Option> options) {
            this.options = options;
            return this;
        }

        public Packet build() {
            return new NeighborDiscoveryOptions(this);
        }

        public Packet build(Memory buffer) {
            while (buffer.isReadable(2)) {
                OptionType type = (OptionType)((Object)OptionType.registry.get(buffer.readByte()));
                byte lengthField = buffer.readByte();
                int dataLength = lengthField * 8;
                if (dataLength < 2 || !buffer.isReadable(dataLength -= 2)) break;
                byte[] data = new byte[dataLength];
                buffer.readBytes(data, 0, dataLength);
                this.options.add(Option.newInstance(type, data));
            }
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new NeighborDiscoveryOptions(this);
        }
    }

    public static final class Option
    implements Serializable {
        private static final long serialVersionUID = -7839083814311096470L;
        private OptionType type;
        private byte length;
        private byte[] data;

        private Option() {
        }

        public static Option newInstance(OptionType type, byte[] data) {
            byte[] newData = new byte[data.length];
            System.arraycopy(data, 0, newData, 0, newData.length);
            Option option = new Option();
            option.type = type;
            option.data = newData;
            option.length = (byte)(option.data.length + 2 + 7 >> 3);
            return option;
        }

        public OptionType getType() {
            return this.type;
        }

        public byte getLength() {
            return this.length;
        }

        public byte[] getData() {
            byte[] data = new byte[this.data.length];
            System.arraycopy(this.data, 0, data, 0, data.length);
            return data;
        }

        public String toString() {
            return "[" + "Type: " + (Object)((Object)this.getType()) + ", Data: " + Arrays.toString(this.getData()) + "]";
        }
    }

    public static class OptionType
    extends NamedNumber<Byte, OptionType> {
        public static final OptionType SOURCE_LINK_LAYER_ADDRESS = new OptionType((byte)1, "Source link layer addresss");
        public static final OptionType TARGET_LINK_LAYER_ADDRESS = new OptionType((byte)2, "Target link layer addresss");
        public static final OptionType PREFIX_INFORMATION = new OptionType((byte)3, "Prefix information");
        public static final OptionType REDIRECT_HEADER = new OptionType((byte)4, "Redirect header");
        public static final OptionType MTU = new OptionType((byte)5, "MTU");
        private static Map<Byte, OptionType> registry = new HashMap<Byte, OptionType>();

        protected OptionType(Byte value, String name) {
            super((Number)value, name);
        }

        static {
            registry.put((Byte)SOURCE_LINK_LAYER_ADDRESS.getValue(), SOURCE_LINK_LAYER_ADDRESS);
            registry.put((Byte)TARGET_LINK_LAYER_ADDRESS.getValue(), TARGET_LINK_LAYER_ADDRESS);
            registry.put((Byte)PREFIX_INFORMATION.getValue(), PREFIX_INFORMATION);
            registry.put((Byte)REDIRECT_HEADER.getValue(), REDIRECT_HEADER);
            registry.put((Byte)MTU.getValue(), MTU);
        }
    }

    public static class Header
    extends AbstractPacket.Header {
        private final List<Option> options;
        private int length;
        private final Builder builder;

        private Header(Builder builder) {
            this.options = builder.options;
            this.buffer = builder.buffer.slice(0, this.getLength());
            this.builder = builder;
        }

        public List<Option> getOptions() {
            return this.options;
        }

        public <T extends NamedNumber> T getPayloadType() {
            return (T)UnknownPacket.UNKNOWN_PAYLOAD_TYPE;
        }

        public int getLength() {
            if (this.length == 0) {
                for (Option option : this.options) {
                    this.length += option.getLength() << 3;
                }
            }
            return this.length;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                for (Option option : this.options) {
                    this.buffer.writeByte((int)((Byte)option.getType().getValue()).byteValue());
                    this.buffer.writeByte((int)option.getLength());
                    this.buffer.writeBytes(option.getData());
                    int paddingLength = (option.getLength() << 3) - (option.getData().length + 2);
                    for (int i = 0; i < paddingLength; ++i) {
                        this.buffer.writeByte(0);
                    }
                }
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\toptions: " + this.options + '\n';
        }
    }
}

