/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ip.ip6;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.TransportLayer;
import com.ardikars.jxpacket.core.ip.Ip6;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Routing
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    private Routing(Builder builder) {
        this.header = new Header(builder);
        this.payload = TransportLayer.valueOf((Byte)((Byte)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "\t[ Routing Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\t\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static final class Type
    extends NamedNumber<Byte, Type> {
        public static final Type UNKNOWN = new Type((byte)-1, "UNKNOWN.");
        public static final Type DEPRECATED_01 = new Type((byte)0, "Due to the fact that with Routing HeaderAbstract type 0 a simple but effective[15] denial-of-service attack could be launched, this header is deprecated since 2007[16] and host and routers are required to ignore these headers.");
        public static final Type DEPRECATED_02 = new Type((byte)1, "Used for the Nimrod[17] project funded by DARPA. It is deprecated since 2009.");
        public static final Type ALLOWED_01 = new Type((byte)2, "A limited version of type 0 and is used for Mobile IPv6, where it can hold the Home Address of the Mobile Node.");
        public static final Type ALLOWED_02 = new Type((byte)3, "RPL Source Route HeaderAbstract[18] for Low-Power and Lossy Networks.");
        public static final Type PRIVATE_USE_01 = new Type((byte)-3, "May be used for testing, not for actual implementations. RFC3692-style Experiment 1.[13]");
        public static final Type PRIVATE_USE_02 = new Type((byte)-2, "May be used for testing, not for actual implementations. RFC3692-style Experiment 2.[13]");
        private static Map<Byte, Type> registry = new HashMap<Byte, Type>();

        protected Type(Byte value, String name) {
            super((Number)value, name);
        }

        public static Type valueOf(byte value) {
            Type type = registry.get(value);
            if (type == null) {
                return UNKNOWN;
            }
            return type;
        }

        public static Type register(Type type) {
            registry.put((Byte)type.getValue(), type);
            return type;
        }

        static {
            registry.put((Byte)DEPRECATED_01.getValue(), DEPRECATED_01);
            registry.put((Byte)DEPRECATED_02.getValue(), DEPRECATED_02);
            registry.put((Byte)ALLOWED_01.getValue(), ALLOWED_01);
            registry.put((Byte)ALLOWED_02.getValue(), ALLOWED_02);
            registry.put((Byte)PRIVATE_USE_01.getValue(), PRIVATE_USE_01);
            registry.put((Byte)PRIVATE_USE_02.getValue(), PRIVATE_USE_02);
        }
    }

    public static final class Builder
    extends AbstractPacket.Builder {
        private TransportLayer nextHeader;
        private byte extensionLength;
        private Type routingType;
        private byte segmentLeft;
        private byte[] routingData;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder nextHeader(TransportLayer nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder extensionLength(int extensionLength) {
            this.extensionLength = (byte)(extensionLength & 0xFF);
            return this;
        }

        public Builder routingType(Type routingType) {
            this.routingType = routingType;
            return this;
        }

        public Builder segmentLeft(int segmentLeft) {
            this.segmentLeft = (byte)(segmentLeft & 0xFF);
            return this;
        }

        public Builder routingData(byte[] routingData) {
            this.routingData = new byte[routingData.length];
            System.arraycopy(routingData, 0, this.routingData, 0, this.routingData.length);
            return this;
        }

        public Routing build() {
            return new Routing(this);
        }

        public Routing build(Memory buffer) {
            this.nextHeader = TransportLayer.valueOf((Byte)buffer.readByte());
            this.extensionLength = buffer.readByte();
            this.routingType = Type.valueOf(buffer.readByte());
            this.segmentLeft = buffer.readByte();
            this.routingData = new byte[4 + 8 * this.extensionLength];
            buffer.readBytes(this.routingData);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Routing(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 4 + this.routingData.length);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.nextHeader != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.extensionLength >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.routingType != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.segmentLeft >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.routingData != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setByte(index, (int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.setByte(++index, (int)this.extensionLength);
                this.buffer.setByte(++index, (int)((Byte)this.routingType.getValue()).byteValue());
                this.buffer.setByte(++index, (int)this.segmentLeft);
                this.buffer.setBytes(++index, this.routingData);
            }
        }
    }

    public static final class Header
    extends Ip6.ExtensionHeader {
        public static final int FIXED_ROUTING_HEADER_LENGTH = 4;
        public static final int FIXED_ROUTING_DATA_LENGTH = 4;
        private final TransportLayer nextHeader;
        private final byte extensionLength;
        private final Type routingType;
        private final byte segmentLeft;
        private final byte[] routingData;
        private final Builder builder;

        private Header(Builder builder) {
            this.nextHeader = builder.nextHeader;
            this.extensionLength = builder.extensionLength;
            this.routingType = builder.routingType;
            this.segmentLeft = builder.segmentLeft;
            this.routingData = builder.routingData;
            this.buffer = builder.buffer.slice(0, this.getLength());
            this.builder = builder;
        }

        public TransportLayer getNextHeader() {
            return this.nextHeader;
        }

        public int getExtensionLength() {
            return this.extensionLength & 0xFF;
        }

        public Type getRoutingType() {
            return this.routingType;
        }

        public int getSegmentLeft() {
            return this.segmentLeft & 0xFF;
        }

        public byte[] getRoutingData() {
            byte[] routingData = new byte[this.routingData.length];
            System.arraycopy(this.routingData, 0, routingData, 0, routingData.length);
            return routingData;
        }

        public TransportLayer getPayloadType() {
            return this.nextHeader;
        }

        public int getLength() {
            return 4 + (this.routingData == null ? 0 : this.routingData.length);
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeByte((int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.writeByte((int)this.extensionLength);
                this.buffer.writeByte((int)((Byte)this.routingType.getValue()).byteValue());
                this.buffer.writeByte((int)this.segmentLeft);
                if (this.routingData != null) {
                    this.buffer.writeBytes(this.routingData);
                }
            }
            return this.buffer;
        }

        public String toString() {
            return "\t\tnextHeader: " + this.nextHeader + '\n' + "\t\textensionLength: " + this.extensionLength + '\n' + "\t\troutingType: " + (Object)((Object)this.routingType) + '\n' + "\t\tsegmentLeft: " + this.segmentLeft + '\n' + "\t\troutingData: " + Arrays.toString(this.routingData) + '\n';
        }

        public Builder getBuilder() {
            return this.builder;
        }
    }
}

