/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ip.ip6;

import com.ardikars.common.memory.Memory;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.layer.TransportLayer;
import com.ardikars.jxpacket.core.ip.Ip6;
import java.util.Arrays;

public abstract class Options
extends AbstractPacket {

    protected static abstract class Builder
    extends AbstractPacket.Builder {
        protected TransportLayer nextHeader;
        protected int extensionLength;
        protected byte[] options;
        protected Memory buffer;
        protected Memory payloadBuffer;

        public Builder(TransportLayer nextHeader) {
            this.nextHeader = nextHeader;
        }

        public Builder extensionLength(int extensionLength) {
            this.extensionLength = extensionLength;
            return this;
        }

        public Builder options(byte[] options) {
            this.options = new byte[options.length];
            System.arraycopy(options, 0, this.options, 0, this.options.length);
            return this;
        }
    }

    protected static abstract class Header
    extends Ip6.ExtensionHeader {
        public static final int FIXED_OPTIONS_LENGTH = 6;
        public static final int LENGTH_UNIT = 8;
        protected final TransportLayer nextHeader;
        protected final int extensionLength;
        protected final byte[] options;

        protected Header(Builder builder, TransportLayer nextHeader) {
            this.nextHeader = nextHeader;
            this.extensionLength = builder.extensionLength;
            this.options = builder.options;
        }

        public TransportLayer getNextHeader() {
            return this.nextHeader;
        }

        public int getExtensionLength() {
            return this.extensionLength;
        }

        public byte[] getOptions() {
            if (this.options != null) {
                byte[] data = new byte[this.options.length];
                System.arraycopy(this.options, 0, data, 0, data.length);
                return data;
            }
            return new byte[0];
        }

        public TransportLayer getPayloadType() {
            return this.nextHeader;
        }

        public int getLength() {
            return 6 + 8 * this.extensionLength;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeByte((int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.writeInt(this.extensionLength);
                if (this.options != null) {
                    this.buffer.writeBytes(this.options);
                }
            }
            return this.buffer;
        }

        public String toString() {
            return "\t\tnextHeader: " + this.nextHeader + '\n' + "\t\textensionLength: " + this.extensionLength + '\n' + "\t\toptions: " + Arrays.toString(this.options) + '\n';
        }
    }
}

