/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ip.ip6;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.TransportLayer;
import com.ardikars.jxpacket.core.ip.ip6.Options;

public class DestinationOptions
extends Options {
    private final Header header;
    private final Packet payload;

    private DestinationOptions(Builder builder) {
        this.header = new Header(builder);
        this.payload = TransportLayer.valueOf((Byte)((Byte)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "\t[ DestinationOptions Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\t\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static final class Builder
    extends Options.Builder {
        public Builder() {
            super(TransportLayer.IPV6_AH);
        }

        public DestinationOptions build() {
            return new DestinationOptions(this);
        }

        public Packet build(Memory buffer) {
            this.nextHeader = TransportLayer.valueOf((Byte)buffer.readByte());
            this.extensionLength = buffer.readInt();
            this.options = new byte[6 + 8 * this.extensionLength];
            buffer.readBytes(this.options);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new DestinationOptions(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 6);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.nextHeader != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.extensionLength >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.options != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setByte(index, (int)((Byte)this.nextHeader.getValue()).byteValue());
                this.buffer.setInt(++index, this.extensionLength);
                this.buffer.setBytes(index += 4, this.options);
            }
        }
    }

    public static final class Header
    extends Options.Header {
        private final Builder builder;

        protected Header(Builder builder) {
            super(builder, builder.nextHeader);
            this.buffer = builder.buffer.slice(0, this.getLength());
            this.builder = builder;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        public Builder getBuilder() {
            return this.builder;
        }
    }
}

