/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ip;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.net.Inet4Address;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.TransportLayer;
import com.ardikars.jxpacket.core.ip.Ip;
import java.util.Arrays;

public class Ip4
extends Ip {
    private final Header header;
    private final Packet payload;

    private Ip4(Builder builder) {
        this.header = new Header(builder);
        this.payload = TransportLayer.valueOf((Byte)((Byte)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Ip4 Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static final class Builder
    extends Ip.AbstractPaketBuilder {
        private byte headerLength;
        private byte diffServ;
        private byte expCon;
        private short totalLength;
        private short identification;
        private byte flags;
        private short fragmentOffset;
        private byte ttl;
        private TransportLayer protocol;
        private short checksum;
        private Inet4Address sourceAddress;
        private Inet4Address destinationAddress;
        private byte[] options;
        private Memory buffer;
        private Memory payloadBuffer;
        private boolean calculateChecksum;

        public Builder headerLength(int headerLength) {
            this.headerLength = (byte)(headerLength & 0xF);
            return this;
        }

        public Builder diffServ(int diffServ) {
            this.diffServ = (byte)(this.diffServ & 0x3F);
            return this;
        }

        public Builder expCon(int expCon) {
            this.expCon = (byte)(expCon & 3);
            return this;
        }

        public Builder totalLength(int totalLength) {
            this.totalLength = (short)(totalLength & 0xFFFF);
            return this;
        }

        public Builder identification(int identification) {
            this.identification = (short)(identification & 0xFFFF);
            return this;
        }

        public Builder flags(int flags) {
            this.flags = (byte)(flags & 7);
            return this;
        }

        public Builder fragmentOffset(int fragmentOffset) {
            this.fragmentOffset = (short)(fragmentOffset & 0x1FFF);
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = (byte)(ttl & 0xFF);
            return this;
        }

        public Builder protocol(TransportLayer protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder checksum(int checksum) {
            this.checksum = (short)(this.checksum & 0xFFFF);
            return this;
        }

        public Builder sourceAddress(Inet4Address sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public Builder destinationAddress(Inet4Address destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public Builder calculateChecksum(boolean calculateChecksum) {
            this.calculateChecksum = calculateChecksum;
            return this;
        }

        public Builder options(byte[] options) {
            this.options = new byte[options.length];
            System.arraycopy(options, 0, this.options, 0, this.options.length);
            return this;
        }

        public Packet build() {
            return new Ip4(this);
        }

        public Packet build(Memory buffer) {
            this.headerLength = (byte)(buffer.readByte() & 0xF);
            byte tmp = buffer.readByte();
            this.diffServ = (byte)(tmp >> 2 & 0x3F);
            this.expCon = (byte)(tmp & 3);
            this.totalLength = buffer.readShort();
            this.identification = buffer.readShort();
            short sscratch = buffer.readShort();
            this.flags = (byte)(sscratch >> 13 & 7);
            this.fragmentOffset = (short)(sscratch & 0x1FFF);
            this.ttl = buffer.readByte();
            this.protocol = TransportLayer.valueOf((Byte)buffer.readByte());
            this.checksum = (short)(buffer.readShort() & 0xFFFF);
            byte[] ipv4Buffer = new byte[4];
            buffer.readBytes(ipv4Buffer);
            this.sourceAddress = Inet4Address.valueOf((byte[])ipv4Buffer);
            ipv4Buffer = new byte[4];
            buffer.readBytes(ipv4Buffer);
            this.destinationAddress = Inet4Address.valueOf((byte[])ipv4Buffer);
            if (this.headerLength > 5) {
                int optionsLength = (this.headerLength - 5) * 4;
                this.options = new byte[optionsLength];
                buffer.readBytes(this.options);
            } else {
                this.options = new byte[0];
            }
            if (this.calculateChecksum) {
                int index = 0;
                int accumulation = 0;
                for (int i = 0; i < this.headerLength * 2; ++i) {
                    accumulation += 0xFFFF & buffer.getShort(index);
                    index += 2;
                }
                if (this.checksum != (short)(~(accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF)) & 0xFFFF)) {
                    this.checksum = 0;
                }
            }
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Ip4(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 20);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.headerLength >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.diffServ >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.expCon >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.totalLength >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.identification >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.flags >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.fragmentOffset >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.ttl >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.protocol != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.checksum >= 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.sourceAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.destinationAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setByte(index, 0x40 | this.headerLength & 0xF);
                int tmp = this.diffServ << 2 & 0x3F | this.expCon & 3;
                this.buffer.setByte(++index, tmp);
                this.buffer.setShort(++index, (int)this.totalLength);
                this.buffer.setShort(index += 2, (int)this.identification);
                int sscratch = this.flags << 13 & 7 | this.fragmentOffset & 0x1FFF;
                this.buffer.setShort(index += 2, sscratch);
                this.buffer.setByte(index += 2, (int)this.ttl);
                this.buffer.setByte(++index, (int)((Byte)this.protocol.getValue()).byteValue());
                this.buffer.setShort(++index, (int)this.checksum);
                this.buffer.setBytes(index += 2, this.sourceAddress.toBytes());
                this.buffer.setBytes(index += 4, this.destinationAddress.toBytes());
                this.buffer.setBytes(index += 4, this.options);
            }
        }
    }

    public static final class Header
    extends Ip.AbstractPacketHeader {
        public static final int IPV4_HEADER_LENGTH = 20;
        private final byte headerLength;
        private final byte diffServ;
        private final byte expCon;
        private final short totalLength;
        private final short identification;
        private final byte flags;
        private final short fragmentOffset;
        private final byte ttl;
        private final TransportLayer protocol;
        private final short checksum;
        private final Inet4Address sourceAddress;
        private final Inet4Address destinationAddress;
        private final byte[] options;
        private final Builder builder;

        protected Header(Builder builder) {
            super((byte)4);
            this.headerLength = builder.headerLength;
            this.diffServ = builder.diffServ;
            this.expCon = builder.expCon;
            this.totalLength = builder.totalLength;
            this.identification = builder.identification;
            this.flags = builder.flags;
            this.fragmentOffset = builder.fragmentOffset;
            this.ttl = builder.ttl;
            this.protocol = builder.protocol;
            this.checksum = builder.checksum;
            this.sourceAddress = builder.sourceAddress;
            this.destinationAddress = builder.destinationAddress;
            this.options = builder.options;
            this.buffer = builder.buffer.slice(0, this.getLength());
            this.builder = builder;
        }

        public int getHeaderLength() {
            return this.headerLength & 0xF;
        }

        public int getDiffServ() {
            return this.diffServ & 0x3F;
        }

        public int getExpCon() {
            return this.expCon & 3;
        }

        public int getTotalLength() {
            return this.totalLength & 0xFFFF;
        }

        public int getIdentification() {
            return this.identification & 0xFFFF;
        }

        public int getFlags() {
            return this.flags & 7;
        }

        public int getFragmentOffset() {
            return this.fragmentOffset & 0x1FFF;
        }

        public int getTtl() {
            return this.ttl & 0xFF;
        }

        public TransportLayer getProtocol() {
            return this.protocol;
        }

        public int getChecksum() {
            return this.checksum & 0xFFFF;
        }

        public Inet4Address getSourceAddress() {
            return this.sourceAddress;
        }

        public Inet4Address getDestinationAddress() {
            return this.destinationAddress;
        }

        public byte[] getOptions() {
            byte[] options = new byte[this.options.length];
            System.arraycopy(this.options, 0, options, 0, options.length);
            return options;
        }

        public boolean isValidChecksum() {
            int accumulation = 0;
            for (int i = 0; i < this.headerLength * 2; ++i) {
                accumulation += 0xFFFF & this.buffer.getShort(0);
            }
            return this.checksum == (short)(~(accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF)) & 0xFFFF);
        }

        public TransportLayer getPayloadType() {
            return this.protocol;
        }

        public int getLength() {
            return 20 + (this.options == null ? 0 : this.options.length);
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeByte((int)((byte)((this.version & 0xF) << 4 | this.headerLength & 0xF)));
                this.buffer.writeByte((int)((byte)(this.diffServ << 2 & 0x3F | this.expCon & 3)));
                this.buffer.writeShort((int)this.totalLength);
                this.buffer.writeShort((int)this.identification);
                this.buffer.writeShort((this.flags & 7) << 13 | this.fragmentOffset & 0x1FFF);
                this.buffer.writeByte((int)this.ttl);
                this.buffer.writeByte((int)((Byte)this.protocol.getValue()).byteValue());
                this.buffer.writeShort(this.checksum & 0xFFFF);
                this.buffer.writeBytes(this.sourceAddress.toBytes());
                this.buffer.writeBytes(this.destinationAddress.toBytes());
                if (this.options != null && this.headerLength > 5) {
                    this.buffer.writeBytes(this.options);
                }
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\tversion: " + this.version + '\n' + "\theaderLength: " + this.headerLength + '\n' + "\tdiffServ: " + this.diffServ + '\n' + "\texpCon: " + this.expCon + '\n' + "\ttotalLength: " + this.totalLength + '\n' + "\tidentification: " + this.identification + '\n' + "\tflags: " + this.flags + '\n' + "\tfragmentOffset: " + this.fragmentOffset + '\n' + "\tttl: " + this.ttl + '\n' + "\tprotocol: " + this.protocol + '\n' + "\tchecksum: " + this.checksum + '\n' + "\tsourceAddress: " + this.sourceAddress + '\n' + "\tdestinationAddress: " + this.destinationAddress + '\n' + "\toptions: " + Arrays.toString(this.options) + '\n';
        }
    }
}

