/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.icmp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import com.ardikars.jxpacket.core.ndp.NeighborAdvertisement;
import com.ardikars.jxpacket.core.ndp.NeighborSolicitation;
import com.ardikars.jxpacket.core.ndp.Redirect;
import com.ardikars.jxpacket.core.ndp.RouterAdvertisement;
import com.ardikars.jxpacket.core.ndp.RouterSolicitation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class Icmp
extends AbstractPacket {
    protected static IcmpTypeAndCode findIcmpTypeAndCode(byte type, byte code, Collection<IcmpTypeAndCode> typeAndCodes) {
        for (IcmpTypeAndCode typeAndCode : typeAndCodes) {
            if (typeAndCode.getType() != type || typeAndCode.getCode() != code) continue;
            return typeAndCode;
        }
        return new IcmpTypeAndCode(type, code, "Unknown");
    }

    public static class IcmpTypeAndCode
    extends NamedNumber<Byte, IcmpTypeAndCode>
    implements Packet.Factory {
        public static final IcmpTypeAndCode NEIGHBOR_SOLICITATION = new IcmpTypeAndCode(-121, 0, "Neighbor Solicitation");
        public static final IcmpTypeAndCode NEIGHBOR_ADVERTISEMENT = new IcmpTypeAndCode(-120, 0, "Neighbor Advertisement");
        public static final IcmpTypeAndCode ROUTER_SOLICICATION = new IcmpTypeAndCode(-123, 0, "Router Solicitation");
        public static final IcmpTypeAndCode ROUTER_ADVERTISEMENT = new IcmpTypeAndCode(-122, 0, "Router Advertisement");
        public static final IcmpTypeAndCode REDIRECT = new IcmpTypeAndCode(-119, 0, "Redirect");
        public static final IcmpTypeAndCode UNKNOWN = new IcmpTypeAndCode(-1, -1, "Unknown");
        private static Map<Byte, IcmpTypeAndCode> registry = new HashMap<Byte, IcmpTypeAndCode>();
        private static Map<Byte, AbstractPacket.Builder> builder = new HashMap<Byte, AbstractPacket.Builder>();
        private final byte type;
        private final byte code;
        private final String name;

        public IcmpTypeAndCode(byte type, byte code, String name) {
            super((Number)type, name);
            this.type = type;
            this.code = code;
            this.name = name;
        }

        public byte getType() {
            return this.type;
        }

        public byte getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "IcmpTypeAndCode{" + "type=" + this.type + ", code=" + this.code + ", name='" + this.name + '\'' + '}';
        }

        public Packet newInstance(Memory buffer) {
            AbstractPacket.Builder packetBuilder = builder.get(this.getValue());
            if (packetBuilder == null) {
                if (buffer == null || buffer.capacity() <= 0) {
                    return null;
                }
                return new UnknownPacket.Builder().build(buffer);
            }
            return (Packet)packetBuilder.build((Object)buffer);
        }

        public static IcmpTypeAndCode valueOf(Byte value) {
            IcmpTypeAndCode icmpTypeAndCode = registry.get(value);
            if (icmpTypeAndCode == null) {
                return UNKNOWN;
            }
            return icmpTypeAndCode;
        }

        public static void register(IcmpTypeAndCode type) {
            registry.put((Byte)type.getValue(), type);
        }

        public static void register(IcmpTypeAndCode type, AbstractPacket.Builder packetBuilder) {
            builder.put((Byte)type.getValue(), packetBuilder);
        }

        static {
            registry.put((Byte)ROUTER_SOLICICATION.getValue(), ROUTER_SOLICICATION);
            registry.put((Byte)ROUTER_ADVERTISEMENT.getValue(), ROUTER_ADVERTISEMENT);
            registry.put((Byte)NEIGHBOR_SOLICITATION.getValue(), NEIGHBOR_SOLICITATION);
            registry.put((Byte)NEIGHBOR_ADVERTISEMENT.getValue(), NEIGHBOR_ADVERTISEMENT);
            registry.put((Byte)REDIRECT.getValue(), REDIRECT);
            IcmpTypeAndCode.register(NEIGHBOR_SOLICITATION, new NeighborSolicitation.Builder());
            IcmpTypeAndCode.register(NEIGHBOR_ADVERTISEMENT, new NeighborAdvertisement.Builder());
            IcmpTypeAndCode.register(ROUTER_SOLICICATION, new RouterSolicitation.Builder());
            IcmpTypeAndCode.register(ROUTER_ADVERTISEMENT, new RouterAdvertisement.Builder());
            IcmpTypeAndCode.register(REDIRECT, new Redirect.Builder());
        }
    }

    protected static abstract class AbstractPacketBuilder
    extends AbstractPacket.Builder {
        protected IcmpTypeAndCode typeAndCode;
        protected short checksum;

        protected AbstractPacketBuilder() {
        }

        public AbstractPacketBuilder typeAndCode(IcmpTypeAndCode typeAndCode) {
            this.typeAndCode = typeAndCode;
            return this;
        }

        public AbstractPacketBuilder checksum(short checksum) {
            this.checksum = checksum;
            return this;
        }
    }

    protected static abstract class AbstractPacketHeader
    extends AbstractPacket.Header {
        public static final int ICMP_HEADER_LENGTH = 4;
        protected IcmpTypeAndCode typeAndCode;
        protected short checksum;

        protected AbstractPacketHeader() {
        }

        public abstract <T extends NamedNumber> T getPayloadType();

        public int getLength() {
            return 4;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeByte((int)this.typeAndCode.getType());
                this.buffer.writeByte((int)this.typeAndCode.getCode());
                this.buffer.writeShort((int)this.checksum);
            }
            return this.buffer;
        }
    }
}

