/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.ethernet;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.net.MacAddress;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.NetworkLayer;

public class Ethernet
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    private Ethernet(Builder builder) {
        this.header = new Header(builder);
        this.payload = NetworkLayer.valueOf((Short)((Short)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public static final Ethernet newPacket(Memory buffer) {
        return new Builder().build(buffer);
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ Ethernet Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static class Builder
    extends AbstractPacket.Builder {
        private MacAddress destinationMacAddress;
        private MacAddress sourceMacAddress;
        private NetworkLayer ethernetType;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder destinationMacAddress(MacAddress destinationMacAddress) {
            this.destinationMacAddress = destinationMacAddress;
            return this;
        }

        public Builder sourceMacAddress(MacAddress sourceMacAddress) {
            this.sourceMacAddress = sourceMacAddress;
            return this;
        }

        public Builder ethernetType(NetworkLayer ethernetType) {
            this.ethernetType = ethernetType;
            return this;
        }

        public Builder payloadBuffer(Memory buffer) {
            this.payloadBuffer = buffer;
            return this;
        }

        public Ethernet build() {
            return new Ethernet(this);
        }

        public Ethernet build(Memory buffer) {
            byte[] hardwareAddressBuffer = new byte[6];
            buffer.readBytes(hardwareAddressBuffer);
            this.destinationMacAddress = MacAddress.valueOf((byte[])hardwareAddressBuffer);
            hardwareAddressBuffer = new byte[6];
            buffer.readBytes(hardwareAddressBuffer);
            this.sourceMacAddress = MacAddress.valueOf((byte[])hardwareAddressBuffer);
            this.ethernetType = NetworkLayer.valueOf((Short)buffer.readShort());
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Ethernet(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 14);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.destinationMacAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.sourceMacAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.ethernetType != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setBytes(index, this.destinationMacAddress.toBytes());
                this.buffer.setBytes(index += 6, this.sourceMacAddress.toBytes());
                this.buffer.setShort(index += 6, (int)((Short)this.ethernetType.getValue()).shortValue());
            }
        }
    }

    public static class Header
    extends AbstractPacket.Header {
        public static final int ETHERNET_HEADER_LENGTH = 14;
        private final MacAddress destinationMacAddress;
        private final MacAddress sourceMacAddress;
        private final NetworkLayer ethernetType;
        private final Builder builder;

        private Header(Builder builder) {
            this.destinationMacAddress = builder.destinationMacAddress;
            this.sourceMacAddress = builder.sourceMacAddress;
            this.ethernetType = builder.ethernetType;
            this.buffer = builder.buffer.slice(0, this.getLength());
            this.builder = builder;
        }

        public MacAddress getDestinationMacAddress() {
            return this.destinationMacAddress;
        }

        public MacAddress getSourceMacAddress() {
            return this.sourceMacAddress;
        }

        public NetworkLayer getEthernetType() {
            return this.ethernetType;
        }

        public NetworkLayer getPayloadType() {
            return this.ethernetType;
        }

        public int getLength() {
            return 14;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeBytes(this.destinationMacAddress.toBytes());
                this.buffer.writeBytes(this.sourceMacAddress.toBytes());
                this.buffer.writeShort((int)((Short)this.ethernetType.getValue()).shortValue());
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\tdestinationMacAddress: " + this.destinationMacAddress + '\n' + "\tsourceMacAddress: " + this.sourceMacAddress + '\n' + "\tethernetType: " + this.ethernetType + '\n';
        }
    }
}

