/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.core.arp;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.net.Inet4Address;
import com.ardikars.common.net.MacAddress;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.common.util.Validate;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.layer.DataLinkLayer;
import com.ardikars.jxpacket.common.layer.NetworkLayer;
import java.util.HashMap;
import java.util.Map;

public class Arp
extends AbstractPacket {
    private final Header header;
    private final Packet payload;

    private Arp(Builder builder) {
        this.header = new Header(builder);
        this.payload = NetworkLayer.valueOf((Short)((Short)this.header.getPayloadType().getValue())).newInstance(builder.payloadBuffer);
        this.payloadBuffer = builder.payloadBuffer;
    }

    public Header getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public static final Arp newPacket(Memory buffer) {
        return new Builder().build(buffer);
    }

    public String toString() {
        return "[ Arp Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + (Object)((Object)this.header) + "\tpayload: " + (this.payload != null ? this.payload.getClass().getSimpleName() : "");
    }

    public static final class OperationCode
    extends NamedNumber<Short, OperationCode> {
        public static final OperationCode ARP_REQUEST = new OperationCode((short)1, "Arp Request");
        public static final OperationCode ARP_REPLY = new OperationCode((short)2, "Arp Reply");
        public static final OperationCode UNKNOWN = new OperationCode((short)-1, "Unknown");
        private static final Map<Short, OperationCode> registry = new HashMap<Short, OperationCode>();

        public OperationCode(Short value, String name) {
            super((Number)value, name);
        }

        public static OperationCode register(OperationCode operationCode) {
            return registry.put((Short)operationCode.getValue(), operationCode);
        }

        public static OperationCode valueOf(Short value) {
            if (registry.containsKey(value)) {
                return registry.get(value);
            }
            return UNKNOWN;
        }

        public String toString() {
            return super.toString();
        }

        static {
            registry.put((Short)ARP_REQUEST.getValue(), ARP_REQUEST);
            registry.put((Short)ARP_REPLY.getValue(), ARP_REPLY);
        }
    }

    public static final class Builder
    extends AbstractPacket.Builder {
        private DataLinkLayer hardwareType;
        private NetworkLayer protocolType;
        private byte hardwareAddressLength;
        private byte protocolAddressLength;
        private OperationCode operationCode;
        private MacAddress senderHardwareAddress;
        private Inet4Address senderProtocolAddress;
        private MacAddress targetHardwareAddress;
        private Inet4Address targetProtocolAddress;
        private Memory buffer;
        private Memory payloadBuffer;

        public Builder hardwareType(DataLinkLayer hardwareType) {
            this.hardwareType = hardwareType;
            return this;
        }

        public Builder protocolType(NetworkLayer protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public Builder hardwareAddressLength(int hardwareAddressLength) {
            this.hardwareAddressLength = (byte)(hardwareAddressLength & 0xFF);
            return this;
        }

        public Builder protocolAddressLength(int protocolAddressLength) {
            this.protocolAddressLength = (byte)(protocolAddressLength & 0xFF);
            return this;
        }

        public Builder operationCode(OperationCode operationCode) {
            this.operationCode = operationCode;
            return this;
        }

        public Builder senderHardwareAddress(MacAddress senderHardwareAddress) {
            this.senderHardwareAddress = senderHardwareAddress;
            return this;
        }

        public Builder senderProtocolAddress(Inet4Address senderProtocolAddress) {
            this.senderProtocolAddress = senderProtocolAddress;
            return this;
        }

        public Builder targetHardwareAddress(MacAddress targetHardwareAddress) {
            this.targetHardwareAddress = targetHardwareAddress;
            return this;
        }

        public Builder targetProtocolAddress(Inet4Address targetProtocolAddress) {
            this.targetProtocolAddress = targetProtocolAddress;
            return this;
        }

        public Builder payloadBuffer(Memory buffer) {
            this.payloadBuffer = buffer;
            return this;
        }

        public Arp build() {
            return new Arp(this);
        }

        public Arp build(Memory buffer) {
            this.hardwareType = DataLinkLayer.valueOf((short)buffer.readShort());
            this.protocolType = NetworkLayer.valueOf((Short)buffer.readShort());
            this.hardwareAddressLength = buffer.readByte();
            this.protocolAddressLength = buffer.readByte();
            this.operationCode = OperationCode.valueOf(buffer.readShort());
            int hardwareAddressLength = this.hardwareAddressLength & 0xFF;
            int protocolAddressLength = this.protocolAddressLength & 0xFF;
            byte[] byteBuffer = new byte[hardwareAddressLength];
            buffer.readBytes(byteBuffer);
            this.senderHardwareAddress = MacAddress.valueOf((byte[])byteBuffer);
            byteBuffer = new byte[protocolAddressLength];
            buffer.readBytes(byteBuffer);
            this.senderProtocolAddress = Inet4Address.valueOf((byte[])byteBuffer);
            byteBuffer = new byte[hardwareAddressLength];
            buffer.readBytes(byteBuffer);
            this.targetHardwareAddress = MacAddress.valueOf((byte[])byteBuffer);
            byteBuffer = new byte[protocolAddressLength];
            buffer.readBytes(byteBuffer);
            this.targetProtocolAddress = Inet4Address.valueOf((byte[])byteBuffer);
            this.buffer = buffer;
            this.payloadBuffer = buffer.slice();
            return new Arp(this);
        }

        public void reset() {
            if (this.buffer != null) {
                this.reset(this.buffer.readerIndex(), 28);
            }
        }

        public void reset(int offset, int length) {
            if (this.buffer != null) {
                Validate.notIllegalArgument((offset + length <= this.buffer.capacity() ? 1 : 0) != 0);
                Validate.notIllegalArgument((this.hardwareType != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.protocolType != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.hardwareAddressLength != 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.protocolAddressLength != 0 ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.senderHardwareAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.senderProtocolAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.targetHardwareAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                Validate.notIllegalArgument((this.targetProtocolAddress != null ? 1 : 0) != 0, (IllegalArgumentException)ILLEGAL_HEADER_EXCEPTION);
                int index = offset;
                this.buffer.setShort(index, (int)((Short)this.hardwareType.getValue()).shortValue());
                this.buffer.setShort(index += 2, (int)((Short)this.protocolType.getValue()).shortValue());
                this.buffer.setByte(index += 2, (int)this.hardwareAddressLength);
                this.buffer.setByte(++index, (int)this.protocolAddressLength);
                this.buffer.setShort(++index, (int)((Short)this.operationCode.getValue()).shortValue());
                this.buffer.setBytes(index += 2, this.senderHardwareAddress.toBytes());
                this.buffer.setBytes(index += 6, this.senderProtocolAddress.toBytes());
                this.buffer.setBytes(index += 4, this.targetHardwareAddress.toBytes());
                this.buffer.setBytes(index += 6, this.targetProtocolAddress.toBytes());
            }
        }
    }

    public static final class Header
    extends AbstractPacket.Header {
        public static final int ARP_HEADER_LENGTH = 28;
        private final DataLinkLayer hardwareType;
        private final NetworkLayer protocolType;
        private final byte hardwareAddressLength;
        private final byte protocolAddressLength;
        private final OperationCode operationCode;
        private final MacAddress senderHardwareAddress;
        private final Inet4Address senderProtocolAddress;
        private final MacAddress targetHardwareAddress;
        private final Inet4Address targetProtocolAddress;
        private final Builder builder;

        private Header(Builder builder) {
            this.hardwareType = builder.hardwareType;
            this.protocolType = builder.protocolType;
            this.hardwareAddressLength = builder.hardwareAddressLength;
            this.protocolAddressLength = builder.protocolAddressLength;
            this.operationCode = builder.operationCode;
            this.senderHardwareAddress = builder.senderHardwareAddress;
            this.senderProtocolAddress = builder.senderProtocolAddress;
            this.targetHardwareAddress = builder.targetHardwareAddress;
            this.targetProtocolAddress = builder.targetProtocolAddress;
            this.buffer = builder.buffer.slice(0, this.getLength());
            this.builder = builder;
        }

        public DataLinkLayer getHardwareType() {
            return this.hardwareType;
        }

        public NetworkLayer getProtocolType() {
            return this.protocolType;
        }

        public int getHardwareAddressLength() {
            return this.hardwareAddressLength & 0xFF;
        }

        public int getProtocolAddressLength() {
            return this.protocolAddressLength & 0xFF;
        }

        public OperationCode getOperationCode() {
            return this.operationCode;
        }

        public MacAddress getSenderHardwareAddress() {
            return this.senderHardwareAddress;
        }

        public Inet4Address getSenderProtocolAddress() {
            return this.senderProtocolAddress;
        }

        public MacAddress getTargetHardwareAddress() {
            return this.targetHardwareAddress;
        }

        public Inet4Address getTargetProtocolAddress() {
            return this.targetProtocolAddress;
        }

        public NetworkLayer getPayloadType() {
            return NetworkLayer.UNKNOWN;
        }

        public int getLength() {
            return 28;
        }

        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(this.getLength());
                this.buffer.writeShort((int)((Short)this.hardwareType.getValue()).shortValue());
                this.buffer.writeShort((int)((Short)this.protocolType.getValue()).shortValue());
                this.buffer.writeByte((int)this.hardwareAddressLength);
                this.buffer.writeByte((int)this.protocolAddressLength);
                this.buffer.writeShort((int)((Short)this.operationCode.getValue()).shortValue());
                this.buffer.writeBytes(this.senderHardwareAddress.toBytes());
                this.buffer.writeBytes(this.senderProtocolAddress.toBytes());
                this.buffer.writeBytes(this.targetHardwareAddress.toBytes());
                this.buffer.writeBytes(this.targetProtocolAddress.toBytes());
            }
            return this.buffer;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\thardwareType: " + this.hardwareType + '\n' + "\tprotocolType: " + this.protocolType + '\n' + "\thardwareAddressLength: " + this.hardwareAddressLength + '\n' + "\tprotocolAddressLength: " + this.protocolAddressLength + '\n' + "\toperationCode: " + (Object)((Object)this.operationCode) + '\n' + "\tsenderHardwareAddress: " + this.senderHardwareAddress + '\n' + "\tsenderProtocolAddress: " + this.senderProtocolAddress + '\n' + "\ttargetHardwareAddress: " + this.targetHardwareAddress + '\n' + "\ttargetProtocolAddress: " + this.targetProtocolAddress + '\n';
        }
    }
}

