/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.common.layer;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import java.util.HashMap;
import java.util.Map;

public final class TransportLayer
extends NamedNumber<Byte, TransportLayer>
implements Packet.Factory {
    public static final TransportLayer ICMP = new TransportLayer((byte)1, "Internet Control Message Protocol Version 4");
    public static final TransportLayer IPV6 = new TransportLayer((byte)41, "IPv6 Header.");
    public static final TransportLayer IPV6_ICMP = new TransportLayer((byte)58, "Internet Control Message Protocol Version 6");
    public static final TransportLayer IPV6_ROUTING = new TransportLayer((byte)43, "Routing Header for IPv6.");
    public static final TransportLayer IPV6_FRAGMENT = new TransportLayer((byte)44, "Fragment Header for IPv6.");
    public static final TransportLayer IPV6_HOPOPT = new TransportLayer((byte)0, "IPv6 Hop by Hop NeighborDiscoveryOptions.");
    public static final TransportLayer IPV6_DSTOPT = new TransportLayer((byte)60, "IPv6 Destination NeighborDiscoveryOptions.");
    public static final TransportLayer IPV6_ESP = new TransportLayer((byte)50, "IPv6 ESP.");
    public static final TransportLayer IPV6_AH = new TransportLayer((byte)51, "IPv6 Authentication Header.");
    public static final TransportLayer IGMP = new TransportLayer((byte)2, "Internet Group Management Protocol");
    public static final TransportLayer TCP = new TransportLayer((byte)6, "Transmission Control Protocol");
    public static final TransportLayer UDP = new TransportLayer((byte)17, "User Datagram Protocol");
    public static final TransportLayer UNKNOWN = new TransportLayer((byte)-1, "Unknown");
    private static Map<Byte, TransportLayer> registry = new HashMap<Byte, TransportLayer>();
    private static Map<Byte, AbstractPacket.Builder> builder = new HashMap<Byte, AbstractPacket.Builder>();

    protected TransportLayer(Byte value, String name) {
        super((Number)value, name);
    }

    public Packet newInstance(Memory buffer) {
        AbstractPacket.Builder packetBuilder = builder.get(this.getValue());
        if (packetBuilder == null) {
            if (buffer == null || buffer.capacity() <= 0) {
                return null;
            }
            return new UnknownPacket.Builder().build(buffer);
        }
        return (Packet)packetBuilder.build(buffer);
    }

    public static TransportLayer valueOf(Byte value) {
        TransportLayer transportLayer = registry.get(value);
        if (transportLayer == null) {
            return UNKNOWN;
        }
        return transportLayer;
    }

    public static void register(TransportLayer type) {
        registry.put((Byte)type.getValue(), type);
    }

    public static void register(TransportLayer type, AbstractPacket.Builder packetBuilder) {
        builder.put((Byte)type.getValue(), packetBuilder);
    }

    static {
        registry.put((Byte)ICMP.getValue(), ICMP);
        registry.put((Byte)IPV6.getValue(), IPV6);
        registry.put((Byte)IPV6_ICMP.getValue(), IPV6_ICMP);
        registry.put((Byte)IPV6_ROUTING.getValue(), IPV6_ROUTING);
        registry.put((Byte)IPV6_FRAGMENT.getValue(), IPV6_FRAGMENT);
        registry.put((Byte)IPV6_HOPOPT.getValue(), IPV6_HOPOPT);
        registry.put((Byte)IPV6_DSTOPT.getValue(), IPV6_DSTOPT);
        registry.put((Byte)IPV6_ESP.getValue(), IPV6_ESP);
        registry.put((Byte)IPV6_AH.getValue(), IPV6_AH);
        registry.put((Byte)IGMP.getValue(), IGMP);
        registry.put((Byte)TCP.getValue(), TCP);
        registry.put((Byte)UDP.getValue(), UDP);
    }
}

