/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.common.layer;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import java.util.HashMap;
import java.util.Map;

public final class NetworkLayer
extends NamedNumber<Short, NetworkLayer>
implements Packet.Factory {
    public static final int IEEE802_3_MAX_LENGTH = 1500;
    public static final NetworkLayer IPV4 = new NetworkLayer((short)2048, "IPv4");
    public static final NetworkLayer ARP = new NetworkLayer((short)2054, "Arp");
    public static final NetworkLayer DOT1Q_VLAN_TAGGED_FRAMES = new NetworkLayer((short)-32512, "IEEE 802.1Q VLAN-tagged frames");
    public static final NetworkLayer IEEE_802_1_AD = new NetworkLayer((short)-30552, "QinQ");
    public static final NetworkLayer RARP = new NetworkLayer((short)-32715, "RARP");
    public static final NetworkLayer APPLETALK = new NetworkLayer((short)-32613, "Appletalk");
    public static final NetworkLayer IPV6 = new NetworkLayer((short)-31011, "IPv6");
    public static final NetworkLayer PPP = new NetworkLayer((short)-30709, "PPP");
    public static final NetworkLayer MPLS = new NetworkLayer((short)-30649, "MPLS");
    public static final NetworkLayer PPPOE_DISCOVERY_STAGE = new NetworkLayer((short)-30621, "PPPoED Discovery Stage");
    public static final NetworkLayer PPPOE_SESSION_STAGE = new NetworkLayer((short)-30620, "PPPoED Session Stage");
    public static final NetworkLayer UNKNOWN = new NetworkLayer((short)-1, "Unknown");
    private static final Map<Short, NetworkLayer> registry = new HashMap<Short, NetworkLayer>();
    private static final Map<Short, AbstractPacket.Builder> builder = new HashMap<Short, AbstractPacket.Builder>();

    public NetworkLayer(Short value, String name) {
        super((Number)value, name);
    }

    public Packet newInstance(Memory buffer) {
        AbstractPacket.Builder packetBuilder = builder.get(this.getValue());
        if (packetBuilder == null) {
            if (buffer == null || buffer.capacity() <= 0) {
                return null;
            }
            return new UnknownPacket.Builder().build(buffer);
        }
        return (Packet)packetBuilder.build(buffer);
    }

    public static NetworkLayer valueOf(Short value) {
        if ((value & 0xFFFF) <= 1500) {
            return UNKNOWN;
        }
        NetworkLayer protocolType = registry.get(value);
        if (protocolType == null) {
            return UNKNOWN;
        }
        return protocolType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(NetworkLayer type) {
        Map<Short, NetworkLayer> map = registry;
        synchronized (map) {
            registry.put((Short)type.getValue(), type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(NetworkLayer networkLayer, AbstractPacket.Builder packetBuilder) {
        Map<Short, AbstractPacket.Builder> map = builder;
        synchronized (map) {
            builder.put((Short)networkLayer.getValue(), packetBuilder);
        }
    }

    public String toString() {
        return super.toString();
    }

    static {
        registry.put((Short)IPV4.getValue(), IPV4);
        registry.put((Short)ARP.getValue(), ARP);
        registry.put((Short)DOT1Q_VLAN_TAGGED_FRAMES.getValue(), DOT1Q_VLAN_TAGGED_FRAMES);
        registry.put((Short)RARP.getValue(), RARP);
        registry.put((Short)APPLETALK.getValue(), APPLETALK);
        registry.put((Short)IPV6.getValue(), IPV6);
        registry.put((Short)PPP.getValue(), PPP);
        registry.put((Short)MPLS.getValue(), MPLS);
        registry.put((Short)PPPOE_DISCOVERY_STAGE.getValue(), PPPOE_DISCOVERY_STAGE);
        registry.put((Short)PPPOE_SESSION_STAGE.getValue(), PPPOE_SESSION_STAGE);
        registry.put((Short)IEEE_802_1_AD.getValue(), IEEE_802_1_AD);
    }
}

