/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.common.layer;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import java.util.HashMap;
import java.util.Map;

public final class DataLinkLayer
extends NamedNumber<Short, DataLinkLayer>
implements Packet.Factory {
    public static final DataLinkLayer EN10MB = new DataLinkLayer((short)1, "Ethernet");
    public static final DataLinkLayer LINUX_SLL = new DataLinkLayer((short)113, "Linux SLL");
    private static final Map<DataLinkLayer, Short> registry = new HashMap<DataLinkLayer, Short>();
    private static final Map<Short, AbstractPacket.Builder> builder = new HashMap<Short, AbstractPacket.Builder>();

    public DataLinkLayer(Short value, String name) {
        super((Number)value, name);
    }

    public Packet newInstance(Memory buffer) {
        AbstractPacket.Builder packetBuilder = builder.get(this.getValue());
        if (packetBuilder == null) {
            if (buffer == null || buffer.capacity() <= 0) {
                return null;
            }
            return new UnknownPacket.Builder().build(buffer);
        }
        return (Packet)packetBuilder.build(buffer);
    }

    public static DataLinkLayer valueOf(short value) {
        for (Map.Entry<DataLinkLayer, Short> entry : registry.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return new DataLinkLayer((short)-1, "Unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(DataLinkLayer dataLinkLayer) {
        Map<DataLinkLayer, Short> map = registry;
        synchronized (map) {
            registry.put(dataLinkLayer, (Short)dataLinkLayer.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(DataLinkLayer dataLinkLayer, AbstractPacket.Builder packetBuilder) {
        Map<Short, AbstractPacket.Builder> map = builder;
        synchronized (map) {
            builder.put((Short)dataLinkLayer.getValue(), packetBuilder);
        }
    }

    static {
        registry.put(EN10MB, (Short)EN10MB.getValue());
        registry.put(LINUX_SLL, (Short)LINUX_SLL.getValue());
    }
}

