/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.common.layer;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.UnknownPacket;
import java.util.HashMap;
import java.util.Map;

public final class ApplicationLayer
extends NamedNumber<Short, ApplicationLayer>
implements Packet.Factory {
    private static final Map<ApplicationLayer, Short> registry = new HashMap<ApplicationLayer, Short>();
    private static final Map<Short, AbstractPacket.Builder> builder = new HashMap<Short, AbstractPacket.Builder>();

    public ApplicationLayer(Short value, String name) {
        super((Number)value, name);
    }

    public Packet newInstance(Memory buffer) {
        AbstractPacket.Builder packetBuilder = builder.get(this.getValue());
        if (packetBuilder == null) {
            if (buffer == null || buffer.capacity() <= 0) {
                return null;
            }
            return new UnknownPacket.Builder().build(buffer);
        }
        return (Packet)packetBuilder.build(buffer);
    }

    public static ApplicationLayer valueOf(short value) {
        for (Map.Entry<ApplicationLayer, Short> entry : registry.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return new ApplicationLayer((short)-1, "Unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ApplicationLayer dataLinkLayer) {
        Map<ApplicationLayer, Short> map = registry;
        synchronized (map) {
            registry.put(dataLinkLayer, (Short)dataLinkLayer.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ApplicationLayer dataLinkLayer, AbstractPacket.Builder packetBuilder) {
        Map<Short, AbstractPacket.Builder> map = builder;
        synchronized (map) {
            builder.put((Short)dataLinkLayer.getValue(), packetBuilder);
        }
    }
}

