/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.common;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.util.NamedNumber;
import com.ardikars.jxpacket.common.AbstractPacket;
import com.ardikars.jxpacket.common.Packet;

public class UnknownPacket
extends AbstractPacket {
    public static final NamedNumber<Integer, ?> UNKNOWN_PAYLOAD_TYPE = null;
    private final Header header;
    private final Packet payload;

    private UnknownPacket(Builder builder) {
        this.header = new Header(builder);
        this.payload = null;
        this.payloadBuffer = builder.payloadBuffer;
    }

    public static UnknownPacket newPacket(Memory buffer) {
        return new Builder().build(buffer);
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[ UnknownPacket Header (" + this.getHeader().getLength() + " bytes) ]" + '\n' + this.header;
    }

    public static final class Builder
    extends AbstractPacket.Builder {
        private Memory payloadBuffer;

        public Builder payloadBuffer(Memory buffer) {
            this.payloadBuffer = buffer;
            return this;
        }

        public UnknownPacket build() {
            return new UnknownPacket(this);
        }

        public UnknownPacket build(Memory buffer) {
            Builder builder = new Builder().payloadBuffer(buffer);
            return new UnknownPacket(builder);
        }

        @Override
        public void reset() {
        }

        @Override
        public void reset(int offset, int length) {
        }
    }

    public static final class Header
    extends AbstractPacket.Header {
        private final Memory buffer;
        private final Builder builder;

        public Header(Builder builder) {
            this.buffer = builder.payloadBuffer;
            this.builder = builder;
        }

        @Override
        public int getLength() {
            return this.buffer.capacity();
        }

        @Override
        public Memory getBuffer() {
            return this.buffer;
        }

        @Override
        public <T extends NamedNumber> T getPayloadType() {
            return (T)UNKNOWN_PAYLOAD_TYPE;
        }

        @Override
        public Builder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return "\tbuffer: " + this.buffer + '\n';
        }
    }
}

