/*
 * Decompiled with CFR 0.152.
 */
package com.ardikars.jxpacket.common;

import com.ardikars.common.memory.Memory;
import com.ardikars.common.memory.MemoryAllocator;
import com.ardikars.common.util.CommonConsumer;
import com.ardikars.jxpacket.common.Packet;
import com.ardikars.jxpacket.common.Properties;
import com.ardikars.jxpacket.common.util.PacketIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPacket
implements Packet {
    protected static final IllegalArgumentException ILLEGAL_HEADER_EXCEPTION = new IllegalArgumentException("Missing required header field(s).");
    protected Memory payloadBuffer;

    public Memory getPayloadBuffer() {
        if (this.payloadBuffer == null) {
            this.payloadBuffer = Properties.BYTE_BUF_ALLOCATOR.allocate(0);
        }
        return this.payloadBuffer;
    }

    @Override
    public <T extends Packet> boolean contains(Class<T> clazz) {
        return !this.get(clazz).isEmpty();
    }

    @Override
    public <T extends Packet> List<T> get(Class<T> clazz) {
        ArrayList<Packet> packets = new ArrayList<Packet>();
        PacketIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Packet packet = (Packet)iterator.next();
            if (!clazz.isInstance(packet)) continue;
            packets.add(packet);
        }
        return packets;
    }

    public PacketIterator iterator() {
        return new PacketIterator(this);
    }

    public void forEach(CommonConsumer<? super Packet> action) throws NullPointerException {
        PacketIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            try {
                action.consume((Object)iterator.next());
            }
            catch (Exception exception) {}
        }
    }

    public static abstract class Factory
    implements com.ardikars.common.util.Factory<Packet, Memory> {
    }

    public static abstract class Builder
    implements com.ardikars.common.util.Builder<Packet, Memory>,
    Serializable {
        public void reset() {
            this.reset(-1, -1);
        }

        public void reset(int offset, int length) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
    }

    public static abstract class Header
    implements Packet.Header {
        protected static final MemoryAllocator ALLOCATOR = Properties.BYTE_BUF_ALLOCATOR;
        protected Memory buffer;

        @Override
        public Memory getBuffer() {
            if (this.buffer == null) {
                this.buffer = ALLOCATOR.allocate(0);
            }
            return this.buffer;
        }

        public abstract Builder getBuilder();
    }
}

