/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.environment;

import org.pitest.bytecode.ASMVersion;
import org.pitest.reloc.asm.AnnotationVisitor;
import org.pitest.reloc.asm.Attribute;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.FieldVisitor;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.RecordComponentVisitor;
import org.pitest.reloc.asm.TypePath;

public class AddAnnotationVisitor
extends ClassVisitor {
    private boolean alreadyAnnotated = false;

    public AddAnnotationVisitor(ClassVisitor classVisitor) {
        super(ASMVersion.asmVersion(), classVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.addAnnotation();
        if (descriptor.equals("Lorg/springframework/test/annotation/DirtiesContext;")) {
            return null;
        }
        return super.visitAnnotation(descriptor, visible);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.addAnnotation();
        return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
    }

    public void visitAttribute(Attribute attribute) {
        this.addAnnotation();
        super.visitAttribute(attribute);
    }

    public void visitNestMember(String nestMember) {
        this.addAnnotation();
        super.visitNestMember(nestMember);
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        this.addAnnotation();
        super.visitPermittedSubclass(permittedSubclass);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.addAnnotation();
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        this.addAnnotation();
        return super.visitRecordComponent(name, descriptor, signature);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.addAnnotation();
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.addAnnotation();
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    private void addAnnotation() {
        if (this.alreadyAnnotated) {
            return;
        }
        AnnotationVisitor annotationVisitor = this.cv.visitAnnotation("Lorg/springframework/test/annotation/DirtiesContext;", true);
        annotationVisitor.visitEnum("classMode", "Lorg/springframework/test/annotation/DirtiesContext$ClassMode;", "AFTER_EACH_TEST_METHOD");
        annotationVisitor.visitEnd();
        this.alreadyAnnotated = true;
    }
}

