/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.core.com.google.common.collect;

import java.util.Comparator;
import java.util.Map;
import repackaged.com.arakelian.core.com.google.common.base.Function;
import repackaged.com.arakelian.core.com.google.common.collect.ByFunctionOrdering;
import repackaged.com.arakelian.core.com.google.common.collect.ComparatorOrdering;
import repackaged.com.arakelian.core.com.google.common.collect.ImmutableList;
import repackaged.com.arakelian.core.com.google.common.collect.Maps;
import repackaged.com.arakelian.core.com.google.common.collect.NaturalOrdering;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    protected Ordering() {
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @Override
    public abstract int compare(T var1, T var2);

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        return ImmutableList.sortedCopyOf(this, elements);
    }
}

