/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.core.enums;

import com.arakelian.core.enums.IsoCountryCode;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public enum IsoCurrencyCode {
    AUD(IsoCountryCode.AU, "Australian Dollar", "AUD", "AUD", "AUD"),
    BGN(IsoCountryCode.BG, "Bulgarian lev", "\u043b\u0432", "&#1083;&#1074;", "\u043b\u0432"),
    BRL(IsoCountryCode.BR, "Brasilian real", "R$", "R$", "R$"),
    CAD(IsoCountryCode.CA, "Canadian Dollar", "CAD", "CAD", "CAD"),
    CHF(IsoCountryCode.CH, "Swiss Franc", "CHF", "CHF", "CHF"),
    CNY(IsoCountryCode.CN, "Chinese Yuan", "\u00a5", "&#165;", "\u00a5"),
    CZK(IsoCountryCode.CZ, "Czech Koruna", "CZK", "CZK", "CZK"),
    DKK(IsoCountryCode.DK, "Danish Krone", "DKK", "DKK", "DKK"),
    EUR(null, "Euro", "\u20ac", "&#8364;", "\u20ac"),
    GBP(IsoCountryCode.GB, "British Pound", "\u00a3", "GBP", "\u00a3"),
    HKD(IsoCountryCode.HK, "Hong Kong dollar", "$", "$", "$"),
    HRK(IsoCountryCode.HR, "Croatian kuna", "kn", "kn", "kn"),
    HUF(IsoCountryCode.HU, "Hungarian Forint", "HUF", "HUF", "HUF"),
    IDR(IsoCountryCode.ID, "Indonesian rupiah", "Rp", "Rp", "Rp"),
    ILS(IsoCountryCode.IL, "Israeli shekel", "\u20aa", "&#8362;", "\u20aa"),
    INR(IsoCountryCode.IN, "Indian rupee", "\u20b9", null, "\u20b9"),
    JPY(IsoCountryCode.JP, "Japanese Yen", "\u00a5", "JPY", "\u00a5"),
    KRW(IsoCountryCode.KR, "South Korean won", "\u20a9", null, "\u20a9"),
    MXN(IsoCountryCode.MX, "Mexican peso", "\u20b1", null, "\u20b1"),
    MYR(IsoCountryCode.MY, "Malaysian ringgit", null, null, null),
    NOK(IsoCountryCode.NO, "Norwegian Krone", "NOK", "NOK", "NOK"),
    NZD(IsoCountryCode.NZ, "New Zealand dollar", "$", "$", "$"),
    PHP(IsoCountryCode.PH, "New Zealand dollar", "\u20b1", null, "\u20b1"),
    PLN(IsoCountryCode.PL, "Polish Zloty", "PLN", "PLN", "PLN"),
    RON(IsoCountryCode.RO, "New Romanian leu", "lei", "lei", "lie"),
    RUB(IsoCountryCode.RU, "Russian Ruble", "\u0440\u0443\u0431.", "\u0440\u0443\u0431.", "\u0440\u0443\u0431."),
    SEK(IsoCountryCode.SE, "Swedish Krona", "SEK", "SEK", "SEK"),
    SGD(IsoCountryCode.SG, "Singapore Dollar", "SGD", "SGD", "SGD"),
    THB(IsoCountryCode.TH, "Thai baht", "\u0e3f", "&#3647;", "\u0e3f"),
    TRY(IsoCountryCode.TR, "Turkish lira", "\u20ba", "&#8378;", "\u20ba"),
    USD(IsoCountryCode.US, "United States Dollar", "$", "&#36;", "$"),
    ZAR(IsoCountryCode.ZA, "South African rand", "R", "R", "R");

    private static final long serialVersionUID = 1L;
    private static final transient Map<IsoCountryCode, IsoCurrencyCode> COUNTRIES;
    private static final transient Map<String, IsoCurrencyCode> CODES;
    private final IsoCountryCode country;
    private final String fullName;
    private final String symbol;
    private final String html;
    private final String abbreviation;

    public static IsoCurrencyCode fromCountry(IsoCountryCode country) {
        if (country != null) {
            return COUNTRIES.get((Object)country);
        }
        return null;
    }

    public static IsoCurrencyCode fromLocaleCountry(Locale locale) {
        IsoCountryCode country = IsoCountryCode.fromLocaleCountry(locale);
        return IsoCurrencyCode.fromCountry(country);
    }

    public static IsoCurrencyCode fromString(String currencyCode) {
        if (currencyCode == null || currencyCode.length() == 0) {
            return null;
        }
        return CODES.get(currencyCode);
    }

    private IsoCurrencyCode(IsoCountryCode country, String fullName, String symbol, String html, String abbreviation) {
        this.country = country;
        this.fullName = fullName;
        this.symbol = symbol;
        this.html = html;
        this.abbreviation = abbreviation;
    }

    public NumberFormat createNumberFormat() {
        Locale locale = this.country == IsoCountryCode.GB ? Locale.UK : Locale.US;
        NumberFormat format = NumberFormat.getCurrencyInstance(locale);
        format.setRoundingMode(RoundingMode.HALF_EVEN);
        return format;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public IsoCountryCode getCountry() {
        return this.country;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getHtml() {
        return this.html;
    }

    public String getResourceBundleKey() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.name();
    }

    public String getSymbol() {
        return this.symbol;
    }

    static {
        HashMap<IsoCountryCode, IsoCurrencyCode> countries = new HashMap<IsoCountryCode, IsoCurrencyCode>();
        TreeMap<String, IsoCurrencyCode> names = new TreeMap<String, IsoCurrencyCode>(String.CASE_INSENSITIVE_ORDER);
        for (IsoCurrencyCode currency : IsoCurrencyCode.values()) {
            names.put(currency.name(), currency);
            IsoCountryCode country = currency.getCountry();
            if (country == null || countries.containsKey((Object)country)) continue;
            countries.put(country, currency);
        }
        COUNTRIES = Collections.unmodifiableMap(countries);
        CODES = Collections.unmodifiableMap(names);
    }
}

