/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.jackson.com.google.common.base;

import repackaged.com.arakelian.jackson.com.google.common.base.Preconditions;
import repackaged.com.arakelian.jackson.com.google.common.base.Predicate;

public abstract class CharMatcher
implements Predicate<Character> {
    public static CharMatcher any() {
        return Any.INSTANCE;
    }

    public static CharMatcher none() {
        return None.INSTANCE;
    }

    protected CharMatcher() {
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new Negated(this);
    }

    @Override
    @Deprecated
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    public String toString() {
        return super.toString();
    }

    private static class Negated
    extends CharMatcher {
        final CharMatcher original;

        Negated(CharMatcher original) {
            this.original = Preconditions.checkNotNull(original);
        }

        @Override
        public boolean matches(char c) {
            return !this.original.matches(c);
        }

        @Override
        public CharMatcher negate() {
            return this.original;
        }

        @Override
        public String toString() {
            String string = String.valueOf(this.original);
            return new StringBuilder(9 + String.valueOf(string).length()).append(string).append(".negate()").toString();
        }
    }

    private static final class None
    extends NamedFastMatcher {
        static final None INSTANCE = new None();

        private None() {
            super("CharMatcher.none()");
        }

        @Override
        public boolean matches(char c) {
            return false;
        }

        @Override
        public CharMatcher negate() {
            return None.any();
        }
    }

    private static final class Any
    extends NamedFastMatcher {
        static final Any INSTANCE = new Any();

        private Any() {
            super("CharMatcher.any()");
        }

        @Override
        public boolean matches(char c) {
            return true;
        }

        @Override
        public CharMatcher negate() {
            return Any.none();
        }
    }

    static class NegatedFastMatcher
    extends Negated {
        NegatedFastMatcher(CharMatcher original) {
            super(original);
        }
    }

    static abstract class NamedFastMatcher
    extends FastMatcher {
        private final String description;

        NamedFastMatcher(String description) {
            this.description = Preconditions.checkNotNull(description);
        }

        @Override
        public final String toString() {
            return this.description;
        }
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher() {
        }

        @Override
        public CharMatcher negate() {
            return new NegatedFastMatcher(this);
        }
    }
}

