/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.databind;

import com.arakelian.core.utils.MoreStringUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.text.Normalizer;

public class TrimWhitespaceDeserializer
extends StdScalarDeserializer<String> {
    private static final long serialVersionUID = 1L;
    public static final TrimWhitespaceDeserializer SINGLETON = new TrimWhitespaceDeserializer();

    private TrimWhitespaceDeserializer() {
        super(String.class);
    }

    public String deserialize(JsonParser p, DeserializationContext context) throws IOException {
        String raw = this.doDeserialize(p, context);
        String value = MoreStringUtils.trimWhitespace((String)raw);
        value = value != null ? Normalizer.normalize(value, Normalizer.Form.NFC) : null;
        return value;
    }

    public String deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }

    private String doDeserialize(JsonParser p, DeserializationContext context) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return p.getText();
        }
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_ARRAY && context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            String parsed = this._parseString(p, context);
            if (p.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, context);
            }
            return parsed;
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = p.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return context.getBase64Variant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        String text = p.getValueAsString();
        if (text != null) {
            return text;
        }
        return (String)context.handleUnexpectedToken(this._valueClass, p);
    }

    public boolean isCachable() {
        return true;
    }
}

