/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.faker.com.google.common.util.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import repackaged.com.arakelian.faker.com.google.common.base.Preconditions;
import repackaged.com.arakelian.faker.com.google.common.util.concurrent.AbstractFuture;
import repackaged.com.arakelian.faker.com.google.common.util.concurrent.DirectExecutor;

public final class MoreExecutors {
    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    static Executor rejectionPropagatingExecutor(final Executor delegate, final AbstractFuture<?> future) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(future);
        if (delegate == MoreExecutors.directExecutor()) {
            return delegate;
        }
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                try {
                    delegate.execute(command);
                }
                catch (RejectedExecutionException e) {
                    future.setException(e);
                }
            }
        };
    }
}

