/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.faker.com.google.common.collect;

import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import repackaged.com.arakelian.faker.com.google.common.base.Preconditions;
import repackaged.com.arakelian.faker.com.google.common.collect.Hashing;
import repackaged.com.arakelian.faker.com.google.common.collect.ImmutableCollection;
import repackaged.com.arakelian.faker.com.google.common.collect.ImmutableList;
import repackaged.com.arakelian.faker.com.google.common.collect.JdkBackedImmutableSet;
import repackaged.com.arakelian.faker.com.google.common.collect.RegularImmutableAsList;
import repackaged.com.arakelian.faker.com.google.common.collect.RegularImmutableSet;
import repackaged.com.arakelian.faker.com.google.common.collect.Sets;
import repackaged.com.arakelian.faker.com.google.common.collect.SingletonImmutableSet;
import repackaged.com.arakelian.faker.com.google.common.collect.UnmodifiableIterator;
import repackaged.com.arakelian.faker.com.google.common.math.IntMath;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element);
    }

    private static <E> ImmutableSet<E> constructUnknownDuplication(int n, Object ... elements) {
        return ImmutableSet.construct(n, Math.max(4, IntMath.sqrt(n, RoundingMode.CEILING)), elements);
    }

    private static <E> ImmutableSet<E> construct(int n, int expectedSize, Object ... elements) {
        switch (n) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object elem = elements[0];
                return ImmutableSet.of(elem);
            }
        }
        SetBuilderImpl builder = new RegularSetBuilderImpl<Object>(expectedSize);
        for (int i = 0; i < n; ++i) {
            Object e = Preconditions.checkNotNull(elements[i]);
            builder = ((SetBuilderImpl)builder).add(e);
        }
        return ((SetBuilderImpl)builder).review().build();
    }

    public static <E> ImmutableSet<E> copyOf(E[] elements) {
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements[0]);
            }
        }
        return ImmutableSet.constructUnknownDuplication(elements.length, (Object[])elements.clone());
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    static int chooseTableSize(int setSize) {
        if ((setSize = Math.max(setSize, 2)) < 0x2CCCCCCC) {
            int tableSize = Integer.highestOneBit(setSize - 1) << 1;
            while ((double)tableSize * 0.7 < (double)setSize) {
                tableSize <<= 1;
            }
            return tableSize;
        }
        Preconditions.checkArgument(setSize < 0x40000000, "collection too large");
        return 0x40000000;
    }

    private static final class JdkBackedSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private final Set<Object> delegate;

        JdkBackedSetBuilderImpl(SetBuilderImpl<E> toCopy) {
            super(toCopy);
            this.delegate = Sets.newHashSetWithExpectedSize(this.distinct);
            for (int i = 0; i < this.distinct; ++i) {
                this.delegate.add(Objects.requireNonNull(this.dedupedElements[i]));
            }
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.delegate.add(e)) {
                this.addDedupedElement(e);
            }
            return this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            return new JdkBackedImmutableSet(this.delegate, ImmutableList.asImmutableList(this.dedupedElements, this.distinct));
        }
    }

    private static final class RegularSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private Object[] hashTable = null;
        private int maxRunBeforeFallback = 0;
        private int expandTableThreshold = 0;
        private int hashCode;

        RegularSetBuilderImpl(int expectedCapacity) {
            super(expectedCapacity);
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.hashTable == null) {
                if (this.distinct == 0) {
                    this.addDedupedElement(e);
                    return this;
                }
                this.ensureTableCapacity(this.dedupedElements.length);
                Object elem = this.dedupedElements[0];
                --this.distinct;
                return this.insertInHashTable(elem).add(e);
            }
            return this.insertInHashTable(e);
        }

        private SetBuilderImpl<E> insertInHashTable(E e) {
            Objects.requireNonNull(this.hashTable);
            int eHash = e.hashCode();
            int i0 = Hashing.smear(eHash);
            int mask = this.hashTable.length - 1;
            int i = i0;
            while (i - i0 < this.maxRunBeforeFallback) {
                int index = i & mask;
                Object tableEntry = this.hashTable[index];
                if (tableEntry == null) {
                    this.addDedupedElement(e);
                    this.hashTable[index] = e;
                    this.hashCode += eHash;
                    this.ensureTableCapacity(this.distinct);
                    return this;
                }
                if (tableEntry.equals(e)) {
                    return this;
                }
                ++i;
            }
            return new JdkBackedSetBuilderImpl<E>(this).add(e);
        }

        @Override
        SetBuilderImpl<E> review() {
            if (this.hashTable == null) {
                return this;
            }
            int targetTableSize = ImmutableSet.chooseTableSize(this.distinct);
            if (targetTableSize * 2 < this.hashTable.length) {
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(targetTableSize, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(targetTableSize);
                this.expandTableThreshold = (int)(0.7 * (double)targetTableSize);
            }
            return RegularSetBuilderImpl.hashFloodingDetected(this.hashTable) ? new JdkBackedSetBuilderImpl(this) : this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            Object[] elements = this.distinct == this.dedupedElements.length ? this.dedupedElements : Arrays.copyOf(this.dedupedElements, this.distinct);
            return new RegularImmutableSet(elements, this.hashCode, Objects.requireNonNull(this.hashTable), this.hashTable.length - 1);
        }

        static Object[] rebuildHashTable(int newTableSize, Object[] elements, int n) {
            Object[] hashTable = new Object[newTableSize];
            int mask = hashTable.length - 1;
            for (int i = 0; i < n; ++i) {
                int j0;
                Object e = Objects.requireNonNull(elements[i]);
                int j = j0 = Hashing.smear(e.hashCode());
                while (true) {
                    int index;
                    if (hashTable[index = j & mask] == null) break;
                    ++j;
                }
                hashTable[index] = e;
            }
            return hashTable;
        }

        void ensureTableCapacity(int minCapacity) {
            int newTableSize;
            if (this.hashTable == null) {
                newTableSize = ImmutableSet.chooseTableSize(minCapacity);
                this.hashTable = new Object[newTableSize];
            } else if (minCapacity > this.expandTableThreshold && this.hashTable.length < 0x40000000) {
                newTableSize = this.hashTable.length * 2;
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(newTableSize, this.dedupedElements, this.distinct);
            } else {
                return;
            }
            this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(newTableSize);
            this.expandTableThreshold = (int)(0.7 * (double)newTableSize);
        }

        static boolean hashFloodingDetected(Object[] hashTable) {
            int maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(hashTable.length);
            int mask = hashTable.length - 1;
            int knownRunStart = 0;
            int knownRunEnd = 0;
            block0: while (knownRunStart < hashTable.length) {
                if (knownRunStart == knownRunEnd && hashTable[knownRunStart] == null) {
                    if (hashTable[knownRunStart + maxRunBeforeFallback - 1 & mask] == null) {
                        knownRunStart += maxRunBeforeFallback;
                    }
                    knownRunEnd = ++knownRunStart;
                    continue;
                }
                for (int j = knownRunStart + maxRunBeforeFallback - 1; j >= knownRunEnd; --j) {
                    if (hashTable[j & mask] != null) continue;
                    knownRunEnd = knownRunStart + maxRunBeforeFallback;
                    knownRunStart = j + 1;
                    continue block0;
                }
                return true;
            }
            return false;
        }

        static int maxRunBeforeFallback(int tableSize) {
            return 13 * IntMath.log2(tableSize, RoundingMode.UNNECESSARY);
        }
    }

    private static abstract class SetBuilderImpl<E> {
        E[] dedupedElements;
        int distinct;

        SetBuilderImpl(int expectedCapacity) {
            this.dedupedElements = new Object[expectedCapacity];
            this.distinct = 0;
        }

        SetBuilderImpl(SetBuilderImpl<E> toCopy) {
            this.dedupedElements = Arrays.copyOf(toCopy.dedupedElements, toCopy.dedupedElements.length);
            this.distinct = toCopy.distinct;
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.dedupedElements.length) {
                int newCapacity = ImmutableCollection.Builder.expandedCapacity(this.dedupedElements.length, minCapacity);
                this.dedupedElements = Arrays.copyOf(this.dedupedElements, newCapacity);
            }
        }

        final void addDedupedElement(E e) {
            this.ensureCapacity(this.distinct + 1);
            this.dedupedElements[this.distinct++] = e;
        }

        abstract SetBuilderImpl<E> add(E var1);

        SetBuilderImpl<E> review() {
            return this;
        }

        abstract ImmutableSet<E> build();
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }

    static abstract class CachingAsList<E>
    extends ImmutableSet<E> {
        private transient ImmutableList<E> asList;

        CachingAsList() {
        }

        @Override
        public ImmutableList<E> asList() {
            ImmutableList<E> result = this.asList;
            if (result == null) {
                this.asList = this.createAsList();
                return this.asList;
            }
            return result;
        }

        ImmutableList<E> createAsList() {
            return new RegularImmutableAsList(this, this.toArray());
        }
    }
}

