/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.faker.model;

import com.arakelian.core.feature.Nullable;
import com.arakelian.core.utils.DateUtils;
import com.arakelian.faker.model.AbstractModel;
import com.arakelian.faker.model.Gender;
import com.arakelian.faker.model.ImmutablePerson;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Value;
import repackaged.com.arakelian.faker.com.google.common.collect.ImmutableMap;

@JsonSerialize(as=ImmutablePerson.class)
@JsonDeserialize(builder=ImmutablePerson.Builder.class)
@JsonPropertyOrder(value={"id", "firstName", "lastName", "title", "gender", "birthdate", "age", "comments", "created", "updated"})
@Value.Immutable
public abstract class Person
extends AbstractModel {
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Person && this.equalTo((Person)another);
    }

    private boolean equalTo(Person another) {
        return Objects.equals(this.getId(), another.getId()) && Objects.equals(this.getFirstName(), another.getFirstName()) && Objects.equals(this.getLastName(), another.getLastName()) && Objects.equals((Object)this.getGender(), (Object)another.getGender()) && Objects.equals(this.getBirthdate(), another.getBirthdate()) && Objects.equals(this.getAge(), another.getAge()) && Objects.equals(this.getTitle(), another.getTitle()) && Objects.equals(this.getComments(), another.getComments()) && Objects.equals(this.getCreated(), another.getCreated()) && Objects.equals(this.getUpdated(), another.getUpdated());
    }

    @Nullable
    @Value.Default
    public Integer getAge() {
        ZonedDateTime dob = this.getBirthdate();
        if (dob == null) {
            return null;
        }
        long years = DateUtils.timeBetween((ZonedDateTime)DateUtils.nowWithZoneUtc(), (ZonedDateTime)dob, (ChronoUnit)ChronoUnit.YEARS);
        return (int)years;
    }

    @Nullable
    public abstract ZonedDateTime getBirthdate();

    @Nullable
    public abstract String getComments();

    public abstract String getFirstName();

    @Nullable
    public abstract Gender getGender();

    public abstract String getLastName();

    @JsonAnyGetter
    @Value.Default
    public Map<String, Object> getProperties() {
        return ImmutableMap.of();
    }

    @Nullable
    public abstract String getTitle();

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.getId());
        h += (h << 5) + Objects.hashCode(this.getFirstName());
        h += (h << 5) + Objects.hashCode(this.getLastName());
        h += (h << 5) + Objects.hashCode((Object)this.getGender());
        h += (h << 5) + Objects.hashCode(this.getBirthdate());
        h += (h << 5) + Objects.hashCode(this.getAge());
        h += (h << 5) + Objects.hashCode(this.getTitle());
        h += (h << 5) + Objects.hashCode(this.getComments());
        h += (h << 5) + Objects.hashCode(this.getCreated());
        h += (h << 5) + Objects.hashCode(this.getUpdated());
        return h;
    }
}

