/*
 * Decompiled with CFR 0.152.
 */
package com.apradanas.simplelinkabletext;

import android.support.annotation.NonNull;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;
import android.widget.TextView;
import com.apradanas.simplelinkabletext.Link;
import com.apradanas.simplelinkabletext.util.Range;

public class ClickableLinkSpan
extends ClickableSpan {
    private Link mLink;
    private Range mRange;

    public ClickableLinkSpan(Link link, Range range) {
        this.mLink = link;
        this.mRange = range;
    }

    public void onClick(View widget) {
        TextView tv = (TextView)widget;
        Spanned s = (Spanned)tv.getText();
        if (this.mLink.getClickListener() != null) {
            this.mLink.getClickListener().onClick(s.subSequence(this.mRange.start, this.mRange.end).toString());
        }
    }

    public void updateDrawState(@NonNull TextPaint ds) {
        if (this.mLink.getTextColor() != 0) {
            ds.setColor(this.mLink.getTextColor());
        }
        ds.setUnderlineText(this.mLink.isUnderlined());
    }
}

