/*
 * Decompiled with CFR 0.152.
 */
package com.apradanas.simplelinkabletext;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.apradanas.simplelinkabletext.Link;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkableTextView
extends TextView {
    private List<Link> mLinks = new ArrayList<Link>();
    private String mText;
    private SpannableString spannable;

    public LinkableTextView(Context context) {
        super(context);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public LinkableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public LinkableTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public LinkableTextView setText(String text) {
        this.mText = text;
        return this;
    }

    public LinkableTextView addLink(Link link) {
        this.mLinks.add(link);
        return this;
    }

    public LinkableTextView addLinks(List<Link> links) {
        this.mLinks.addAll(links);
        return this;
    }

    private void addLinkToSpan(Link link) {
        if (this.spannable == null) {
            this.spannable = SpannableString.valueOf((CharSequence)this.mText);
        }
        this.addLinkToSpan((Spannable)this.spannable, link);
    }

    private void addLinkToSpan(Spannable s, Link link) {
        Pattern pattern = Pattern.compile(Pattern.quote(link.getText()));
        Matcher matcher = pattern.matcher(this.mText);
        while (matcher.find()) {
            int start = matcher.start();
            if (start < 0) continue;
            int end = start + link.getText().length();
            this.applyLink(link, new Range(start, end), s);
        }
    }

    private void applyLink(final Link link, final Range range, Spannable text) {
        ClickableSpan span = new ClickableSpan(){

            public void onClick(View widget) {
                TextView tv = (TextView)widget;
                Spanned s = (Spanned)tv.getText();
                if (link.getClickListener() != null) {
                    link.getClickListener().onClick(s.subSequence(range.start, range.end).toString());
                }
            }

            public void updateDrawState(TextPaint ds) {
                if (link.getTextColor() != 0) {
                    ds.setColor(link.getTextColor());
                }
                ds.setUnderlineText(link.isUnderlined());
            }
        };
        text.setSpan((Object)span, range.start, range.end, 33);
    }

    private void convertPatternsToLinks() {
        int size = this.mLinks.size();
        int i = 0;
        while (i < size) {
            if (this.mLinks.get(i).getPattern() != null) {
                this.addLinksFromPattern(this.mLinks.get(i));
                this.mLinks.remove(i);
                --size;
                continue;
            }
            ++i;
        }
    }

    private void addLinksFromPattern(Link linkWithPattern) {
        Pattern pattern = linkWithPattern.getPattern();
        Matcher m = pattern.matcher(this.mText);
        while (m.find()) {
            Link link = new Link(linkWithPattern).setText(m.group());
            this.mLinks.add(link);
        }
    }

    public LinkableTextView build() {
        this.convertPatternsToLinks();
        for (Link link : this.mLinks) {
            this.addLinkToSpan(link);
        }
        this.setText((CharSequence)this.spannable);
        return this;
    }

    private static class Range {
        public int start;
        public int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

