/*
 * Decompiled with CFR 0.152.
 */
package com.appzilo.sdk.video.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.core.content.ContextCompat;

public class ResourcesUtil {
    private static Context sContext;
    private static Resources sRes;

    public static void init(Context context) {
        sContext = context;
        sRes = sContext.getResources();
    }

    public static String getString(String string2) {
        int n = sRes.getIdentifier(string2, "string", sContext.getPackageName());
        if (n == 0) {
            return string2;
        }
        return sRes.getString(n);
    }

    public static String getString(int n) {
        Context context = sContext;
        if (context != null) {
            return context.getString(n);
        }
        if (context != null) {
            context.getString(n);
        }
        return "";
    }

    public static CharSequence getText(int n) {
        return sContext.getText(n);
    }

    public static int getDrawable(String string2) {
        return sRes.getIdentifier(string2, "drawable", sContext.getPackageName());
    }

    public static Drawable getDrawable(int n) {
        return ContextCompat.getDrawable((Context)sContext, (int)n);
    }

    public static int getColor(int n) {
        if (Build.VERSION.SDK_INT >= 23) {
            return sRes.getColor(n, sContext.getTheme());
        }
        return sRes.getColor(n);
    }
}

