package com.appzilo.sdk.video.core;

import android.webkit.CookieManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class SyncCookieHandler implements CookieJar {
    private CookieManager webviewCookieManager = CookieManager.getInstance();

    @Override
    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        String urlString = url.toString();
        for (Cookie cookie : cookies) {
            webviewCookieManager.setCookie(urlString, cookie.toString());
            webviewCookieManager.setCookie("https://www.appzilo.com", createAzCookie(cookie).toString());
//            webviewCookieManager.setCookie("https://app.getmoocash.com", createMooCookie(cookie).toString());
        }
    }

    private Cookie createAzCookie(Cookie cookie) {
        return new Cookie.Builder()
                .domain("www.appzilo.com")
                .path("/")
                .name(cookie.name())
                .value(cookie.value())
                .build();
    }

    private Cookie createMooCookie(Cookie cookie) {
        return new Cookie.Builder()
                .domain("app.getmoocash.com")
                .path("/")
                .name(cookie.name())
                .value(cookie.value())
                .build();
    }

    @Override
    public List<Cookie> loadForRequest(HttpUrl url) {
        String urlString = url.toString();
        String cookiesString = null;

        try {
            cookiesString = webviewCookieManager.getCookie(urlString);
        } catch (IllegalStateException ignored) {
        }
        if (cookiesString != null && !cookiesString.isEmpty()) {
            //We can split on the ';' char as the cookie manager only returns cookies
            //that match the url and haven't expired, so the cookie attributes aren't included
            String[] cookieHeaders = cookiesString.split(";");
            List<Cookie> cookies = new ArrayList<>(cookieHeaders.length);

            for (String header : cookieHeaders) {
                Cookie cookie = Cookie.parse(url, header);
                if (cookie != null && cookie.value() != null && cookie.name() != null) {
                    cookies.add(cookie);
                }
            }

            return cookies;
        }

        return Collections.emptyList();
    }
}
