package com.appzilo.sdk.video.backend;

import android.content.Context;

import com.appzilo.sdk.video.backend.model.NoticeResponse;
import com.appzilo.sdk.video.core.App;
import com.appzilo.sdk.video.core.Error;
import com.appzilo.sdk.video.core.Http;
import com.appzilo.sdk.video.core.Result;
import com.appzilo.sdk.video.utils.SharedPreferencesUtil;
import com.appzilo.sdk.video.utils.Utils;
import com.google.gson.JsonSyntaxException;

import java.util.HashMap;
import java.util.Map;

public class NoticeApi {
    public static final String NOTICE_RESPONSE = "notice_response";
    public final static String APP_KEY = "app_key";
    public final static String TYPE = "ty";
    private final String NOTICE_TAG = "notice_tag";
    private Context mContext;
    private String baseUrl = App.getIsLive() ? "https://www.appzilo.com/sdk_notice/?" : "https://www.uploadhub.com/appzilo/sdk_notice/?";

    public NoticeApi(Context context) {
        mContext = context;
    }

    public static NoticeResponse getNoticeResponse(Context context) {
        SharedPreferencesUtil pref = new SharedPreferencesUtil(context);
        NoticeResponse response = null;
        String noticeResponse = pref.getStringValue(NOTICE_RESPONSE, null);
        try {
            response = App.gson().fromJson(noticeResponse, NoticeResponse.class);
        } catch (JsonSyntaxException ignored) {
        }
        if (response != null) {
            return processResponse(response);
        }

        return null;
    }

    private static NoticeResponse processResponse(NoticeResponse response){
        return response;
    }

    public Result request(HashMap<String, String> publisherInfo) {
        NoticeResponse response = null;
        if (!Utils.isOnline(mContext)) {
            return new Result(Error.OFFLINE);
        }
        Map<String, String> params = new HashMap<>();
        String app_key = publisherInfo.get(APP_KEY);
        publisherInfo.remove(APP_KEY);
        if (!params.containsKey(TYPE)) {
            params.put(TYPE, "video");
        }
        params.putAll(getParams(NOTICE_TAG));
        params.putAll(publisherInfo);
        Http.Request request = Http.request(mContext, app_key)
                .url(baseUrl)
                .post(params)
                .tag(NOTICE_TAG);
        Result result = request.send();
        if (result.isSuccess()) {
            SharedPreferencesUtil pref = new SharedPreferencesUtil(mContext);
            String responseText = (String) result.getResult();

            try {
                response = App.gson().fromJson(responseText, NoticeResponse.class);
            } catch (JsonSyntaxException ex) {
                ex.printStackTrace();
            }
            if (response != null) {
                if (response.credential.success) pref.putStringValue(NOTICE_RESPONSE, responseText);
                return new Result(null, processResponse(response));
            }
            return new Result(Error.DATA);
        }

        return new Result(Error.NETWORK);
    }

    private Map<String, String> getParams(String tag) {
        Map<String, String> params = new HashMap<>();
        if (Utils.isDebug(mContext) &&  !App.getIsDebug()) {
            params.put("dbg", "1");
        }
        switch (tag) {
            case NOTICE_TAG:
                params.put("view", "json");
                return params;
            default:
                return params;
        }
    }
}
